/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.jaxm.soap;

import com.sap.engine.lib.xml.Symbols;
import javax.xml.soap.Name;

public class SOAPNameImpl
implements Name {
    private String prefix = null;
    private String localName = null;
    private String uri = null;

    public SOAPNameImpl() {
    }

    public SOAPNameImpl(String qname, String uri) {
        this.prefix = this.getPrefix(qname);
        this.localName = this.getLocalName(qname);
        if (!Symbols.isName((String)this.localName)) {
            throw new RuntimeException('\"' + this.localName + "' is not a valid name.");
        }
        this.uri = uri;
    }

    public SOAPNameImpl(String prefix, String localName, String uri) {
        if (!Symbols.isName((String)localName)) {
            throw new RuntimeException('\"' + localName + "' is not a valid name.");
        }
        this.prefix = prefix;
        this.localName = localName;
        this.uri = uri;
    }

    public SOAPNameImpl init(String qname, String uri) {
        this.prefix = this.getPrefix(qname);
        this.localName = this.getLocalName(qname);
        this.uri = uri;
        return this;
    }

    public SOAPNameImpl init(String prefix, String localName, String uri) {
        this.prefix = prefix;
        this.localName = localName;
        this.uri = uri;
        return this;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        if (this.prefix == null || this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getURI() {
        return this.uri;
    }

    private String getPrefix(String qname) {
        int separator = qname.indexOf(58);
        if (separator == -1) {
            return "";
        }
        return qname.substring(0, separator);
    }

    private String getLocalName(String qname) {
        int separator = qname.indexOf(58);
        if (separator == -1) {
            return qname;
        }
        return qname.substring(separator + 1);
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object x) {
        Name xn;
        if (x == null) {
            return false;
        }
        if (x instanceof Name && this.compareString((xn = (Name)x).getLocalName(), this.getLocalName()) && this.compareString(xn.getPrefix(), this.getPrefix()) && this.compareString(xn.getURI(), this.getURI())) {
            return true;
        }
        return super.equals(x);
    }

    private boolean compareString(String ns1, String ns2) {
        if (ns1 == ns2) {
            return true;
        }
        if (ns1 != null && ns1.equals(ns2)) {
            return true;
        }
        return ns2 != null && ns2.equals(ns1);
    }
}

