/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures.decorations;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class TargetTextDecoration
extends Label
implements RotatableDecoration {
    private double INITIAL;
    private double myTheta;
    private int myGap;
    private Point myOriginalLocation;

    public TargetTextDecoration(String text, Image icon) {
        super(text, icon);
        this.myTheta = this.INITIAL = Double.MAX_VALUE;
        this.myGap = 10;
    }

    public void setTargetGap(int gap) {
        this.myGap = gap;
    }

    public void setReferencePoint(Point ref) {
        double oldTheta = this.myTheta;
        int x = ref.x - this.myOriginalLocation.x;
        int y = ref.y - this.myOriginalLocation.y;
        this.myTheta = Math.atan2(y, x);
        if (oldTheta == this.INITIAL) {
            Point loc = this.getLocation();
            this.setBounds(new Rectangle(loc.x, loc.y, 0, 0));
        }
    }

    public void setBounds(Rectangle bounds) {
        if (this.myTheta == this.INITIAL) {
            super.setBounds(bounds);
            this.myOriginalLocation = new Point(bounds.getLocation());
            return;
        }
        bounds.setSize(this.getPreferredSize());
        super.setBounds(bounds);
        Rectangle boundsCopy = new Rectangle(bounds);
        Point loc = boundsCopy.getLocation();
        this.myOriginalLocation = new Point(loc);
        boundsCopy.setLocation(this.correctLocation(loc));
        super.setBounds(boundsCopy);
    }

    protected Point correctLocation(Point loc) {
        Dimension size = this.getSize();
        loc.x = Math.abs(this.myTheta) > 1.5707963267948966 ? (loc.x -= size.width + this.myGap) : (loc.x += this.myGap);
        loc.y = this.myTheta < 0.0 ? (loc.y -= size.height + this.myGap) : (loc.y += this.myGap);
        return loc;
    }
}

