/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures.compartments;

import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.internal.viewmaps.figures.compartments.Compartment;
import com.tssap.selena.internal.viewmaps.figures.compartments.Compartments;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ModelCompartments
extends Compartments {
    public static final String HIDDEN = "hidden";
    public static final String CLASS_COMPARTMENT = "classes";
    public static final String PROPERTY_COMPARTMENT = "properties";
    public static final String INTERFACE_COMPARTMENT = "interfaces";
    public static final String OPERATION_COMPARTMENT = "operations";
    public static final String ATTRIBUTE_COMPARTMENT = "attributes";
    public static final String PACKAGE_COMPARTMENT = "packages";
    public static final String PATTERN_COMPARTMENT = "patterns";
    public static final String PARTICIPANT_COMPARTMENT = "participants";
    protected static final Map ourMetaclassCompartmentNames = new HashMap();
    protected static final Collection ourDefaultCompartments = new HashSet();

    public ModelCompartments(ModelNodeEditPart ep, String[] defaultCompartments) {
        if (defaultCompartments != null) {
            int dci = 0;
            while (dci < defaultCompartments.length) {
                String meta = ModelCompartments.getMetaclass(defaultCompartments[dci]);
                boolean defaultCompartment = ourDefaultCompartments.contains(meta);
                this.getCompartment(ep, defaultCompartments[dci], defaultCompartment);
                ++dci;
            }
        }
    }

    public Compartment getCompartment(ModelNodeEditPart ep) {
        String metaclass = ep.getElement().getPropertyValue("$metaclass");
        String name = this.getCompartmentName(metaclass);
        if (name == null) {
            name = HIDDEN;
            ep.setHidden(true);
        }
        return this.getCompartment((ModelNodeEditPart)ep.getParent(), name, false);
    }

    protected String getCompartmentName(String metaclass) {
        return (String)ourMetaclassCompartmentNames.get(metaclass);
    }

    protected static String getMetaclass(String name) {
        Iterator keys = ourMetaclassCompartmentNames.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!ourMetaclassCompartmentNames.get(key).equals(name)) continue;
            return (String)key;
        }
        return null;
    }

    static {
        ourMetaclassCompartmentNames.put("Class", CLASS_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Interface", INTERFACE_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Operation", OPERATION_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Attribute", ATTRIBUTE_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Package", PACKAGE_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Package Diagram", PACKAGE_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Pattern", PATTERN_COMPARTMENT);
        ourMetaclassCompartmentNames.put("Property", PROPERTY_COMPARTMENT);
        ourMetaclassCompartmentNames.put("All", PARTICIPANT_COMPARTMENT);
        ourDefaultCompartments.add("Attribute");
        ourDefaultCompartments.add("Operation");
    }
}

