/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures.compartments;

import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.draw2d.layouts.ShrinkablePileLayout;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.internal.viewmaps.figures.compartments.CompartmentLabel;
import com.tssap.selena.internal.viewmaps.figures.compartments.CompartmentScrollPane;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.events.MouseEvent;

public class Compartment {
    private IFigure myParent;
    private CompartmentLabel myLabel;
    private ScrollPane myChildrenPane;
    private IFigure myChildren;
    private boolean myChildrenAdded;
    private boolean myIsLabelRemovable;
    private ModelNodeEditPart myEditPart;
    private PropertyMap myMap;
    private String myPropertyName;
    private String myMetaclass;
    private boolean myIsDefault;
    private boolean myIsHidden;
    private static Comparator COMPARATOR = new LabelComparator();

    public Compartment(ModelNodeEditPart editPart, IFigure parent, String name, String metaclass, boolean def) {
        this(editPart, parent, name, metaclass, def, false);
    }

    public Compartment(ModelNodeEditPart editPart, IFigure parent, String name, String metaclass, boolean def, boolean hidden) {
        this.setHidden(hidden);
        this.myParent = parent;
        this.myEditPart = editPart;
        this.myMap = editPart.getElement();
        this.myMetaclass = metaclass;
        this.myIsDefault = def;
        this.myLabel = new CompartmentLabel(name, true);
        this.myLabel.setDecorationsVisible(false);
        this.myLabel.setForegroundColor(parent.getForegroundColor());
        if (this.myMap != null && !Boolean.TRUE.toString().equals(this.myMap.getPropertyValue("hideAll")) && (def || this.hasModelChildren())) {
            this.myParent.add((IFigure)this.myLabel);
        }
        this.myChildren = new ShrinkableFigure();
        FlowLayout layout = new FlowLayout(false);
        layout.setFill(true);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        this.myChildren.setLayoutManager((LayoutManager)layout);
        this.myChildren.add((IFigure)new GlueFigure());
        this.myChildrenPane = new CompartmentScrollPane();
        this.myChildrenPane.setHorizontalScrollBarVisibility(0);
        this.myChildrenPane.setView(this.myChildren);
    }

    public void setLabelRemovable(boolean removable) {
        this.myIsLabelRemovable = removable;
    }

    public void setHidden(boolean hidden) {
        this.myIsHidden = hidden;
    }

    public boolean isLabelRemovable() {
        return this.myIsLabelRemovable;
    }

    public void setPropertyName(String name) {
        if (name != null && this.myMap != null) {
            boolean on = Boolean.TRUE.toString().equals(this.myMap.getPropertyValue(name));
            this.myLabel.setState(!on);
        }
        this.myPropertyName = name;
    }

    public String getName() {
        return this.myLabel.getText();
    }

    public void setDecorationsVisible(boolean visible) {
        this.myLabel.setDecorationsVisible(visible);
    }

    public void toggle() {
        this.myLabel.toggle();
        if (this.myMap == null || this.myPropertyName == null) {
            this.updateChildrenView();
        } else {
            DiagramNode node;
            this.updateChildrenView();
            boolean hasProperty = Boolean.TRUE.toString().equals(this.myMap.getPropertyValue(this.myPropertyName));
            this.myMap.setPropertyValue(this.myPropertyName, hasProperty ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
            Reference reference = (Reference)this.myEditPart.getElement();
            if (this.myEditPart.getDiagram() != null && (node = (DiagramNode)this.myEditPart.getDiagram().findDiagramElement((Reference)this.myMap)) != null) {
                node.adjustSize(true);
                node.getDiagram().doPartialLayout();
            }
        }
    }

    public boolean isEmpty() {
        return this.myChildren.getChildren().isEmpty();
    }

    public boolean containsFigure(IFigure figure) {
        return this.myChildren.getChildren().contains(figure);
    }

    public final void add(IFigure figure, Object constraint) {
        this.add(figure, constraint, -1);
    }

    public final void add(IFigure figure) {
        this.add(figure, null, -1);
    }

    public final void add(IFigure figure, int index) {
        this.add(figure, null, index);
    }

    public void add(IFigure figure, Object constraints, int index) {
        if (this.myIsHidden) {
            return;
        }
        if (!this.myParent.getChildren().contains((Object)this.myLabel)) {
            int childindex = this.myParent.getChildren().indexOf(this.myChildrenPane);
            if (childindex >= 0) {
                this.myParent.add((IFigure)this.myLabel, childindex);
            } else {
                this.myParent.add((IFigure)this.myLabel);
            }
        }
        this.myChildren.add(figure, constraints, index);
        this.updateChildrenView();
    }

    public void addAfter(IFigure figure, IFigure reference) {
        if (this.myIsHidden) {
            return;
        }
        this.updateLabel(true);
        if (!this.myLabel.isOn()) {
            this.myLabel.toggle();
        }
        Compartment.addAfter(this.myChildren, figure, reference, null);
        this.updateChildrenView();
    }

    private static void addAfter(IFigure container, IFigure figure, IFigure reference, Object constraint) {
        if (reference == null) {
            container.add(figure, constraint, 0);
            return;
        }
        List children = container.getChildren();
        int referenceIndex = children.indexOf(reference);
        container.add(figure, constraint, referenceIndex < 0 ? -1 : referenceIndex + 1);
    }

    public void remove(IFigure figure) {
        if (this.myIsHidden) {
            return;
        }
        if (!this.hasModelChildren()) {
            this.updateLabel(this.myChildren.getChildren().size() - 1 > 0);
            if (!this.myIsDefault && this.myParent.getChildren().contains((Object)this.myLabel)) {
                this.myParent.remove((IFigure)this.myLabel);
            }
        }
        this.myChildren.remove(figure);
        this.updateChildrenView();
    }

    private void updateLabel(boolean on) {
        if (this.myIsHidden) {
            return;
        }
        if (this.isLabelRemovable()) {
            if (!this.myLabel.isOn()) {
                this.myLabel.toggle();
            }
            this.myLabel.setVisible(on);
        }
    }

    boolean handleMouseUp(MouseEvent me) {
        if (this.myLabel.getParent() != null && this.myLabel.isDecorationsVisible() && me.button == 1) {
            Point eventLocation = new Point(me.x, me.y);
            this.myLabel.translateToRelative((Translatable)eventLocation);
            if (this.myLabel.getIconBounds().contains(eventLocation)) {
                this.toggle();
                return true;
            }
        }
        return false;
    }

    protected void updateChildrenView() {
        if (this.myLabel.isOn() && !this.isEmpty()) {
            if (!this.myChildrenAdded) {
                Compartment.addAfter(this.myParent, (IFigure)this.myChildrenPane, (IFigure)this.myLabel, this.myChildren);
                this.myChildrenAdded = true;
            }
        } else if (this.myChildrenAdded) {
            this.myParent.remove((IFigure)this.myChildrenPane);
            this.myChildrenAdded = false;
        }
    }

    protected boolean isHidden() {
        return this.myIsHidden;
    }

    protected PropertyMap getPropertyMap() {
        return this.myMap;
    }

    protected String getMetaclass() {
        return this.myMetaclass;
    }

    protected boolean hasModelChildren() {
        if (this.isHidden()) {
            return false;
        }
        if (this.myEditPart == null) {
            return true;
        }
        return this.myEditPart.hasChild(this.getMetaclass());
    }

    private static class GlueFigure
    extends InvisibleRectangle {
        private GlueFigure() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getParent().getBounds().width, 0);
        }
    }

    private static class LabelComparator
    implements Comparator {
        private Comparator myTextComparator = Collator.getInstance();

        private LabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Label && o2 instanceof Label) {
                String t1 = ((Label)o1).getText();
                String t2 = ((Label)o2).getText();
                t1 = this.prepareString(t1);
                t2 = this.prepareString(t2);
                return this.myTextComparator.compare(t1, t2);
            }
            return 0;
        }

        private String prepareString(String t) {
            return t.replace('+', '1').replace('#', '2').replace(' ', '3').replace('-', '4');
        }
    }

    private static class ShrinkableFigure
    extends Figure
    implements ShrinkablePileLayout.ShrinkableConstraint {
        private ShrinkableFigure() {
        }

        public boolean canShrink() {
            return this.getChildren().size() > 1;
        }

        public List getChildren() {
            ArrayList children = new ArrayList(super.getChildren());
            Collections.sort(children, COMPARATOR);
            return children;
        }
    }
}

