/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures;

import com.tssap.selena.internal.viewmaps.FontUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TextLabel
extends Label {
    protected boolean myUnderlined;

    public TextLabel(String name) {
        super(name);
        this.setFont(FontUtil.getDefaultFont());
        this.setLabelAlignment(1);
    }

    public TextLabel(String name, Image icon) {
        this(name);
        this.setIcon(icon);
    }

    public TextLabel(Image icon) {
        this("");
        this.setIcon(icon);
    }

    public void setUnderlined(boolean b) {
        this.myUnderlined = b;
    }

    public boolean isUnderlined() {
        return this.myUnderlined;
    }

    public void setForegroundColor(Color color) {
        if (color == null) {
            return;
        }
        super.setForegroundColor(color);
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            return;
        }
        super.setBackgroundColor(color);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.isUnderlined()) {
            Rectangle bounds = this.getBounds();
            graphics.translate(bounds.x, bounds.y);
            Point location = this.getTextLocation();
            Dimension size = this.getSubStringTextSize();
            graphics.drawLine(location.x, location.y + size.height - 1, location.x + size.width, location.y + size.height - 1);
            graphics.translate(-bounds.x, -bounds.y);
        }
    }
}

