/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class Folder
extends Shape {
    private static final float SUPPLEMENT_WIDTH_RATIO = 0.4f;
    private static final int SUPPLEMENT_HEIGTH = 20;
    private IFigure myPadding = new Figure();

    public Folder() {
        this.myPadding.setMinimumSize(new Dimension(1, 22));
        this.myPadding.setPreferredSize(new Dimension(20, 22));
        this.myPadding.setMaximumSize(new Dimension(20, 22));
        this.add(this.myPadding);
    }

    public IFigure getPadding() {
        return this.myPadding;
    }

    protected Rectangle getSupplementRectangle(Rectangle bounds) {
        int w = (int)((float)bounds.width * 0.4f);
        int h = Math.min(bounds.height, 20);
        return new Rectangle(bounds.x, bounds.y, w, h);
    }

    protected Rectangle getMainRectangle(Rectangle bounds) {
        int x = bounds.x;
        int y = bounds.y + Math.min(bounds.height, 20);
        int w = bounds.width;
        int h = Math.max(0, bounds.height - 20);
        return new Rectangle(x, y, w, h);
    }

    protected void fillShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.fillRectangle(this.getSupplementRectangle(bounds));
        graphics.fillRectangle(this.getMainRectangle(bounds));
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        Rectangle shiftedBounds = new Rectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        graphics.drawRectangle(this.getSupplementRectangle(shiftedBounds));
        graphics.drawRectangle(this.getMainRectangle(shiftedBounds));
    }
}

