/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps.figures;

import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramElement;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.gde.internal.DiagramNode;
import com.tssap.selena.internal.viewmaps.FontUtil;
import com.tssap.selena.internal.viewmaps.figures.TextLabel;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.HashMap;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeListener;

public class AncestorsList
extends Figure
implements NodeListener {
    private ModelNodeEditPart myEditPart;
    private Model myModel;
    private HashMap myLabels = new HashMap();
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";

    public AncestorsList(ModelNodeEditPart editPart) {
        this.myEditPart = editPart;
        this.myEditPart.addNodeListener((NodeListener)this);
        this.myModel = editPart.getElement().getModel();
        FlowLayout layout = new FlowLayout(false);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        layout.setAlignment(2);
        this.setLayoutManager((LayoutManager)layout);
        this.createLabels(editPart);
    }

    public void sourceConnectionAdded(ConnectionEditPart connection, int index) {
        Entity target = ((Reference)((ModelNodeEditPart)connection.getTarget()).getElement()).getEntity();
        Entity link = ((Reference)connection.getModel()).getEntity();
        if (this.isLink(link)) {
            TextLabel label = (TextLabel)((Object)this.myLabels.remove(target.getPropertyValue("$fullName")));
            if (label == null) {
                label = (TextLabel)((Object)this.myLabels.remove(target.getPropertyValue("$name")));
            }
            if (label != null) {
                this.remove((IFigure)label);
            }
        }
    }

    public void removingSourceConnection(ConnectionEditPart connection, int index) {
        Entity target = ((Reference)((ModelNodeEditPart)connection.getTarget()).getElement()).getEntity();
        Entity link = ((Reference)connection.getModel()).getEntity();
        if (this.isLink(link) && !link.isDeleted() && !target.isDeleted()) {
            boolean isAbstract;
            String name = target.getPropertyValue("$fullName");
            boolean bl = isAbstract = target.getPropertyValue("$abstract") != null;
            if (name != null) {
                TextLabel label = new TextLabel(name);
                if (isAbstract) {
                    label.setFont(FontUtil.getFont(2));
                }
                this.myLabels.put(name, label);
                this.add((IFigure)label);
            }
        }
    }

    public void removingTargetConnection(ConnectionEditPart connection, int index) {
    }

    public void targetConnectionAdded(ConnectionEditPart connection, int index) {
    }

    public void createLabels(ModelNodeEditPart ep) {
        Entity entity = ((Reference)ep.getElement()).getEntity();
        PropertyEnumeration names = entity.properties("$extends");
        while (names.hasMoreElements()) {
            Property name = names.next();
            String targetName = name.getValue();
            if (JAVA_LANG_OBJECT.equals(targetName) || ((DiagramImpl)ep.getDiagram()).containsClass(targetName)) continue;
            TextLabel label = new TextLabel(targetName);
            this.myLabels.put(targetName, label);
            this.add((IFigure)label);
        }
        PropertyEnumeration names2 = entity.properties("$implements");
        while (names2.hasMoreElements()) {
            Property name = names2.next();
            String targetName = name.getValue();
            if (JAVA_LANG_OBJECT.equals(targetName) || ((DiagramImpl)ep.getDiagram()).containsClass(targetName)) continue;
            TextLabel label = new TextLabel(targetName);
            label.setFont(FontUtil.getFont(2));
            this.myLabels.put(targetName, label);
            this.add((IFigure)label);
        }
    }

    private void adjustSize() {
        if (this.myEditPart == null || this.myEditPart.getElement() == null || this.myEditPart.getDiagram() == null) {
            return;
        }
        Reference reference = (Reference)this.myEditPart.getElement();
        DiagramElement element = (DiagramElement)this.myEditPart.getDiagram().findDiagramElement(reference);
        if (element instanceof DiagramNode) {
            ((DiagramNode)element).adjustSize(true);
        }
    }

    private boolean isLink(Entity child) {
        String metaclass = child.getPropertyValue("$metaclass");
        return "Extends Link".equals(metaclass) || "Implementation Link".equals(metaclass) || "Generalization Link".equals(metaclass);
    }
}

