/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps;

import com.tssap.selena.internal.viewmaps.ImageAccess;
import com.tssap.selena.internal.viewmaps.ImageAccessImpl;
import com.tssap.selena.internal.viewmaps.ModelImageDescriptor;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.ui.internal.CachingImageDescriptor;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ModelImageProvider
extends LabelProvider {
    protected static final Point SMALL_SIZE = new Point(16, 16);
    private DescriptorsCache myDescriptorsCache = new DescriptorsCache();

    public Image getImage(Object object) {
        Image image;
        String metaclass;
        if (object != null && !"Package Diagram".equals(metaclass = ((Element)object).getPropertyValue("$metaclass")) && (image = ChromePlugin.getInstance().getImageBundle().getImage(metaclass)) != null) {
            return image;
        }
        CachingImageDescriptor descriptor = this.myDescriptorsCache.getDescriptor((Element)object);
        return descriptor.getImage();
    }

    public String getText(Object element) {
        return null;
    }

    public void dispose() {
        this.myDescriptorsCache.dispose();
    }

    private static class DescriptorsCache {
        private ImageAccess myBaseImages = new ImageAccessImpl();
        private HashMap myDescriptors = new HashMap(30);

        public DescriptorsCache() {
            this.myBaseImages = new ImageAccessImpl();
            this.myDescriptors = new HashMap(30);
        }

        public void dispose() {
            Iterator descriptors = this.myDescriptors.values().iterator();
            while (descriptors.hasNext()) {
                CachingImageDescriptor curDescriptor = (CachingImageDescriptor)descriptors.next();
                curDescriptor.dispose();
            }
            this.myDescriptors.clear();
            this.myDescriptors = null;
        }

        public CachingImageDescriptor getDescriptor(Element element) {
            String wholeKey;
            CachingImageDescriptor result;
            Entity entity = null;
            entity = element instanceof Reference ? ((Reference)element).getEntity() : (Entity)element;
            int modifiers = DescriptorsCache.getModifiers(entity);
            String baseKey = this.myBaseImages.getBaseImageKey(entity, modifiers);
            int adornmentKey = DescriptorsCache.calculateAdornmentFlags(modifiers);
            if (element instanceof Reference && element.getPropertyValue("$imported") != null) {
                adornmentKey |= 0x4000;
            }
            if ((result = (CachingImageDescriptor)this.myDescriptors.get(wholeKey = baseKey + adornmentKey)) == null) {
                ImageDescriptor baseDescriptor = this.myBaseImages.getBaseImageDescriptor(entity, modifiers);
                ModelImageDescriptor compositeDescriptor = new ModelImageDescriptor(baseDescriptor, adornmentKey, SMALL_SIZE);
                result = new CachingImageDescriptor((ImageDescriptor)compositeDescriptor);
                this.myDescriptors.put(wholeKey, result);
            }
            return result;
        }

        private static int calculateAdornmentFlags(int modifiers) {
            int result = 0;
            if ((modifiers & 8) > 0) {
                result |= 1;
            }
            if ((modifiers & 0x40) > 0) {
                result |= 2;
            }
            if ((modifiers & 0x20) > 0) {
                result |= 8;
            }
            if ((modifiers & 0x800) > 0) {
                result |= 4;
            }
            if ((modifiers & 0x4000) > 0) {
                result |= 0x2000;
            }
            return result;
        }

        private static int getModifiers(Entity entity) {
            String modifiersString = entity.getPropertyValue("modifiers");
            if (modifiersString == null) {
                return 0;
            }
            int modifiers = 0;
            try {
                modifiers = Integer.parseInt(modifiersString);
            }
            catch (NumberFormatException parsingFails) {
                return 0;
            }
            PropertyEnumeration selfPatterns = entity.properties("$self_pattern");
            if (selfPatterns != null && selfPatterns.hasMoreElements()) {
                modifiers |= 0x4000;
            }
            return modifiers;
        }
    }
}

