/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.viewmaps;

import com.tssap.selena.model.preferences.PreferencesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontUtil {
    private static Font ourNormalFont;
    private static Font ourItalicFont;
    private static Font ourBoldItalicFont;
    private static Font ourBoldFont;
    private static final IPreferenceStore PREF_STORE;
    private static final String DIAGRAM_FONT_PROPERTY = "diagramFont";

    public static Font getDefaultFont() {
        return FontUtil.getFont(0);
    }

    public static Font getFont(int style) {
        if ((1 & style) == 0) {
            if ((2 & style) == 0) {
                return FontUtil.getNormalFont();
            }
            return FontUtil.getItalicFont();
        }
        if ((2 & style) == 0) {
            return FontUtil.getBoldFont();
        }
        return FontUtil.getBoldItalicFont();
    }

    private static Font getBoldItalicFont() {
        if (ourBoldItalicFont == null) {
            ourBoldItalicFont = FontUtil.createFont(3);
        }
        return ourBoldItalicFont;
    }

    private static Font getBoldFont() {
        if (ourBoldFont == null) {
            ourBoldFont = FontUtil.createFont(1);
        }
        return ourBoldFont;
    }

    private static Font getItalicFont() {
        if (ourItalicFont == null) {
            ourItalicFont = FontUtil.createFont(2);
        }
        return ourItalicFont;
    }

    private static Font createFont(int style) {
        FontData data = FontUtil.getNormalFont().getFontData()[0];
        FontData newFontData = new FontData(data.getName(), data.getHeight(), data.getStyle() | style);
        return new Font(null, newFontData);
    }

    private static Font getNormalFont() {
        if (ourNormalFont == null) {
            FontUtil.updateFont();
        }
        if (ourNormalFont == null) {
            ourNormalFont = JFaceResources.getDefaultFont();
        }
        return ourNormalFont;
    }

    private static void updateFont() {
        FontData newFontData = PreferenceConverter.getFontData((IPreferenceStore)PREF_STORE, (String)DIAGRAM_FONT_PROPERTY);
        if (newFontData == null) {
            return;
        }
        if (ourNormalFont == null || !newFontData.equals((Object)ourNormalFont.getFontData()[0])) {
            if (ourNormalFont != null) {
                ourNormalFont.dispose();
            }
            ourNormalFont = new Font(null, newFontData);
            if (ourBoldFont != null) {
                ourBoldFont.dispose();
                ourBoldFont = null;
            }
            if (ourItalicFont != null) {
                ourItalicFont.dispose();
                ourItalicFont = null;
            }
            if (ourBoldItalicFont != null) {
                ourBoldItalicFont.dispose();
                ourBoldItalicFont = null;
            }
        }
    }

    static {
        PREF_STORE = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
        PREF_STORE.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (FontUtil.DIAGRAM_FONT_PROPERTY.equals(event.getProperty())) {
                    FontUtil.updateFont();
                }
            }
        });
    }
}

