/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.policy;

import com.sap.security.core.codesecurity.policy.PersistenceAdapter;
import java.io.File;
import java.security.GeneralSecurityException;

public class PropertyReplacer {
    private PropertyReplacer() {
    }

    public static String replace(String withplaceholders) throws PropertyReplacerException {
        if (withplaceholders == null) {
            return null;
        }
        int propstart = withplaceholders.indexOf("${", 0);
        if (propstart == -1) {
            return withplaceholders;
        }
        int length = withplaceholders.length();
        StringBuffer realvalue = new StringBuffer(length);
        int replacestart = 0;
        while (propstart < length) {
            if (propstart > replacestart) {
                realvalue.append(withplaceholders.substring(replacestart, propstart));
                replacestart = propstart;
            }
            int index = propstart + 2;
            while (index < length && withplaceholders.charAt(index) != '}') {
                ++index;
            }
            if (index == length) {
                realvalue.append(withplaceholders.substring(propstart, index));
                break;
            }
            String propname = withplaceholders.substring(propstart + 2, index);
            if (propname.equals("/")) {
                realvalue.append(File.separatorChar);
            } else {
                String propval = PersistenceAdapter.getPropertyPrivileged(propname);
                if (propval != null) {
                    realvalue.append(propval);
                } else {
                    throw new PropertyReplacerException("unable to expand property " + propname);
                }
            }
            replacestart = index + 1;
            propstart = withplaceholders.indexOf("${", replacestart);
            if (propstart != -1) continue;
            if (replacestart >= length) break;
            realvalue.append(withplaceholders.substring(replacestart, length));
            break;
        }
        return realvalue.toString();
    }

    public static class PropertyReplacerException
    extends GeneralSecurityException {
        public PropertyReplacerException(String message) {
            super(message);
        }
    }
}

