/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.policy;

import com.sap.security.core.codesecurity.policy.PermissionEntry;
import com.sap.security.core.codesecurity.policy.PersistenceAdapter;
import com.sap.security.core.codesecurity.policy.PersistenceAdapterException;
import com.sap.security.core.codesecurity.policy.PortalPolicy;
import com.sap.security.core.codesecurity.policy.ProtectionDomainEntry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnresolvedPermission;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class PortalPolicy
extends Policy {
    private PersistenceAdapter persistenceAdapter = null;
    private Hashtable canonicalizedCodeSources = new Hashtable();
    private static final Class[] stringArr = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PortalPolicy.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PortalPolicy.class$("java.lang.String")) : class$java$lang$String};
    private static Hashtable permissionConstructors = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public PortalPolicy() {
        this.init();
    }

    public void refresh() {
        this.init();
    }

    private void init() {
        try {
            this.persistenceAdapter = PersistenceAdapter.getPersistenceAdapter(true);
        }
        catch (PersistenceAdapterException pae) {
            pae.printStackTrace();
        }
    }

    private CodeSource canonicalizeCodebase(CodeSource rawCS, boolean allowRemote) {
        CodeSource canonicalizedCS;
        block12: {
            if (this.canonicalizedCodeSources.containsKey(rawCS)) {
                return (CodeSource)this.canonicalizedCodeSources.get(rawCS);
            }
            canonicalizedCS = rawCS;
            if (rawCS.getLocation() != null && rawCS.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    String path = rawCS.getLocation().getFile().replace('/', File.separatorChar);
                    URL url = null;
                    if (path.endsWith("*")) {
                        path = path.substring(0, path.length() - 1);
                        boolean flag1 = false;
                        if (path.endsWith(File.separator)) {
                            flag1 = true;
                        }
                        if (path.equals("")) {
                            path = (String)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return System.getProperty("user.dir");
                                }
                            });
                        }
                        File file = new File(path);
                        path = file.getCanonicalPath();
                        StringBuffer stringbuffer = new StringBuffer(path);
                        if (!path.endsWith(File.separator) && (flag1 || file.isDirectory())) {
                            stringbuffer.append(File.separatorChar);
                        }
                        stringbuffer.append('*');
                        path = stringbuffer.toString();
                    } else {
                        path = new File(path).getCanonicalPath();
                    }
                    url = new File(path).toURL();
                    if (allowRemote) {
                        canonicalizedCS = new CodeSource(url, null);
                        break block12;
                    }
                    canonicalizedCS = new CodeSource(url, rawCS.getCertificates());
                }
                catch (IOException ioexception) {
                    if (allowRemote) {
                        canonicalizedCS = new CodeSource(rawCS.getLocation(), null);
                    }
                    break block12;
                }
            }
            if (allowRemote) {
                canonicalizedCS = new CodeSource(rawCS.getLocation(), null);
            }
        }
        this.canonicalizedCodeSources.put(rawCS, canonicalizedCS);
        return canonicalizedCS;
    }

    public PermissionCollection getPermissions(CodeSource thatCodesource) {
        Permissions outPerms = new Permissions();
        thatCodesource = this.canonicalizeCodebase(thatCodesource, true);
        Enumeration enumeration = this.persistenceAdapter.protectionDomainElements();
        while (enumeration.hasMoreElements()) {
            ProtectionDomainEntry pdEntry = (ProtectionDomainEntry)enumeration.nextElement();
            try {
                boolean mustAdd;
                boolean bl = mustAdd = pdEntry.mm_codeBase == null;
                if (!mustAdd) {
                    URL entryUrl = new URL(pdEntry.mm_codeBase);
                    CodeSource thisCodesource = this.canonicalizeCodebase(new CodeSource(entryUrl, null), true);
                    mustAdd = thisCodesource.implies(thatCodesource);
                }
                if (!mustAdd) continue;
                Iterator iter = ((AbstractList)pdEntry.mm_permissionEntries).iterator();
                while (iter.hasNext()) {
                    PermissionEntry permentry = (PermissionEntry)iter.next();
                    Permission perm = PortalPolicy.getPermissionObject(permentry.mm_permissiontype, permentry.mm_name, permentry.mm_action);
                    outPerms.add(perm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return outPerms;
    }

    private static final Permission getPermissionObject(String classname, String name, String action) throws Exception {
        Constructor permissionConstructor = (Constructor)permissionConstructors.get(classname);
        if (permissionConstructor != null) {
            try {
                return (Permission)permissionConstructor.newInstance(name, action);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Class<?> permissionclass = null;
        try {
            permissionclass = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe) {
            return new UnresolvedPermission(classname, name, action, null);
        }
        Constructor c = null;
        try {
            class DoGetConstructor
            implements PrivilegedExceptionAction {
                private Class cl;

                public DoGetConstructor(Class cl) {
                    this.cl = null;
                    this.cl = cl;
                }

                public Object run() throws NoSuchMethodException {
                    return this.cl.getConstructor(PortalPolicy.access$000());
                }
            }
            c = (Constructor)AccessController.doPrivileged(new DoGetConstructor(permissionclass));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        permissionConstructors.put(classname, c);
        return (Permission)c.newInstance(name, action);
    }

    static /* synthetic */ Class[] access$000() {
        return stringArr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

