/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.policy;

import com.sap.security.core.codesecurity.policy.KeyStoreEntry;
import com.sap.security.core.codesecurity.policy.PermissionEntry;
import com.sap.security.core.codesecurity.policy.PersistenceAdapter;
import com.sap.security.core.codesecurity.policy.PersistenceAdapterException;
import com.sap.security.core.codesecurity.policy.PolicyParserException;
import com.sap.security.core.codesecurity.policy.PropertyReplacer;
import com.sap.security.core.codesecurity.policy.ProtectionDomainEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;

public class PolicyFileParser
extends PersistenceAdapter {
    private StreamTokenizer mm_tokenizer;
    private int mm_lookahead;
    private String policyfile = null;

    public PolicyFileParser() {
    }

    public PolicyFileParser(boolean flag) {
        super(flag);
    }

    public PolicyFileParser(String policyfile, boolean replaceprops) throws PolicyParserException {
        if (policyfile == null) {
            throw new PolicyParserException("policyfile cannot be null");
        }
        this.policyfile = policyfile;
    }

    public PolicyFileParser(String policyfile) throws PolicyParserException {
        this(policyfile, false);
    }

    public void initAdapterImpl() throws PersistenceAdapterException {
        block4: {
            boolean throwException = false;
            try {
                if (this.policyfile == null) {
                    throwException = true;
                    this.policyfile = PersistenceAdapter.getPropertyPrivileged("java.security.policy", "/");
                    if (this.policyfile.startsWith("=")) {
                        this.policyfile = this.policyfile.substring(1);
                    }
                }
                InputStreamReader r = new InputStreamReader(new FileInputStream(this.policyfile.replace('/', File.separatorChar)));
                this.parse(r);
                r.close();
            }
            catch (IOException ioe) {
                if (!throwException) break block4;
                throw new PolicyParserException("could not read policy file: " + ioe.getMessage());
            }
        }
    }

    protected void upload(String policyName) {
        PrintWriter wr = new PrintWriter(System.out);
        this.print(wr);
    }

    public void parse(Reader reader) throws PolicyParserException, IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.mm_tokenizer = new StreamTokenizer(reader);
        this.mm_tokenizer.resetSyntax();
        this.mm_tokenizer.wordChars(97, 122);
        this.mm_tokenizer.wordChars(65, 90);
        this.mm_tokenizer.wordChars(46, 46);
        this.mm_tokenizer.wordChars(48, 57);
        this.mm_tokenizer.wordChars(95, 95);
        this.mm_tokenizer.wordChars(36, 36);
        this.mm_tokenizer.wordChars(160, 255);
        this.mm_tokenizer.whitespaceChars(0, 32);
        this.mm_tokenizer.quoteChar(39);
        this.mm_tokenizer.quoteChar(34);
        this.mm_tokenizer.lowerCaseMode(false);
        this.mm_tokenizer.slashSlashComments(true);
        this.mm_tokenizer.slashStarComments(true);
        this.mm_lookahead = this.mm_tokenizer.nextToken();
        while (this.mm_lookahead != -1) {
            if (this.checkToken("grant")) {
                ProtectionDomainEntry pdEntry = this.parseProtectionDomainEntry();
                if (pdEntry != null) {
                    this.add(pdEntry);
                }
            } else if (this.checkToken("keystore") && this.mm_keystore.isEmpty()) {
                this.mm_keystore = this.parseKeyStoreEntry();
            }
            this.readToken(";");
        }
    }

    private KeyStoreEntry parseKeyStoreEntry() throws PolicyParserException, IOException {
        KeyStoreEntry kse = new KeyStoreEntry(this.mm_replaceProp);
        this.readToken("keystore");
        kse.mm_keyStoreUrlString = this.readToken("quoted string");
        if (!this.checkToken(",")) {
            return kse;
        }
        this.readToken(",");
        if (!this.checkToken("\"")) {
            throw new PolicyParserException(this.mm_tokenizer.lineno(), "no keystore type found");
        }
        kse.mm_keyStoreType = this.readToken("quoted string");
        return kse;
    }

    private ProtectionDomainEntry parseProtectionDomainEntry() throws PolicyParserException, IOException {
        ProtectionDomainEntry pdentry = new ProtectionDomainEntry();
        this.readToken("grant");
        while (!this.checkToken("{")) {
            if (this.checkAndReadToken("codebase")) {
                pdentry.mm_codeBase = this.readToken("quoted string");
                this.checkAndReadToken(",");
                continue;
            }
            if (this.checkAndReadToken("SignedBy")) {
                pdentry.mm_signedBy = this.readToken("quoted string");
                this.checkAndReadToken(",");
                continue;
            }
            throw new PolicyParserException(this.mm_tokenizer.lineno(), "expected codeBase or SignedBy");
        }
        this.readToken("{");
        while (!this.checkToken("}")) {
            if (this.checkToken("permission")) {
                try {
                    PermissionEntry permissionentry = this.parsePermissionEntry();
                    pdentry.add(permissionentry);
                }
                catch (PropertyReplacer.PropertyReplacerException re) {
                    this.skipEntry();
                }
                this.readToken(";");
                continue;
            }
            throw new PolicyParserException(this.mm_tokenizer.lineno(), "expected permission entry");
        }
        this.readToken("}");
        try {
            if (pdentry.mm_codeBase != null) {
                pdentry.mm_codeBase = this.replaceProps(pdentry.mm_codeBase).replace(File.separatorChar, '/');
            }
            pdentry.mm_signedBy = this.replaceProps(pdentry.mm_signedBy);
        }
        catch (PropertyReplacer.PropertyReplacerException re) {
            return null;
        }
        return pdentry;
    }

    private PermissionEntry parsePermissionEntry() throws PolicyParserException, IOException, PropertyReplacer.PropertyReplacerException {
        PermissionEntry permissionentry = new PermissionEntry();
        this.readToken("permission");
        permissionentry.mm_permissiontype = this.readToken("permission type");
        if (this.checkToken("\"")) {
            permissionentry.mm_name = this.replaceProps(this.readToken("quoted string"));
        }
        if (!this.checkToken(",")) {
            return permissionentry;
        }
        this.readToken(",");
        if (this.checkToken("\"")) {
            permissionentry.mm_action = this.replaceProps(this.readToken("quoted string"));
        }
        return permissionentry;
    }

    private boolean checkAndReadToken(String tok) throws PolicyParserException, IOException {
        if (this.checkToken(tok)) {
            this.readToken(tok);
            return true;
        }
        return false;
    }

    private boolean checkToken(String tok) {
        boolean flag = false;
        switch (this.mm_lookahead) {
            default: {
                break;
            }
            case -3: {
                if (!tok.equalsIgnoreCase(this.mm_tokenizer.sval)) break;
                flag = true;
                break;
            }
            case 44: {
                if (!tok.equalsIgnoreCase(",")) break;
                flag = true;
                break;
            }
            case 123: {
                if (!tok.equalsIgnoreCase("{")) break;
                flag = true;
                break;
            }
            case 125: {
                if (!tok.equalsIgnoreCase("}")) break;
                flag = true;
                break;
            }
            case 34: {
                if (!tok.equalsIgnoreCase("\"")) break;
                flag = true;
            }
        }
        return flag;
    }

    private String readToken(String tok) throws PolicyParserException, IOException {
        String sval = null;
        switch (this.mm_lookahead) {
            case -2: {
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, "number " + String.valueOf(this.mm_tokenizer.nval));
            }
            case -1: {
                throw new PolicyParserException("expected " + tok + ", read end of file");
            }
            case -3: {
                if (tok.equalsIgnoreCase(this.mm_tokenizer.sval)) {
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                if (tok.equalsIgnoreCase("permission type")) {
                    sval = this.mm_tokenizer.sval;
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, this.mm_tokenizer.sval);
            }
            case 34: {
                if (tok.equalsIgnoreCase("quoted string")) {
                    sval = this.mm_tokenizer.sval;
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                if (tok.equalsIgnoreCase("permission type")) {
                    sval = this.mm_tokenizer.sval;
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, this.mm_tokenizer.sval);
            }
            case 44: {
                if (tok.equalsIgnoreCase(",")) {
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, ",");
            }
            case 123: {
                if (tok.equalsIgnoreCase("{")) {
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, "{");
            }
            case 125: {
                if (tok.equalsIgnoreCase("}")) {
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, "}");
            }
            case 59: {
                if (tok.equalsIgnoreCase(";")) {
                    this.mm_lookahead = this.mm_tokenizer.nextToken();
                    break;
                }
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, ";");
            }
            default: {
                throw new PolicyParserException(this.mm_tokenizer.lineno(), tok, new String(new char[]{(char)this.mm_lookahead}));
            }
        }
        return sval;
    }

    private void skipEntry() throws PolicyParserException, IOException {
        while (this.mm_lookahead != 59) {
            switch (this.mm_lookahead) {
                case -2: {
                    throw new PolicyParserException(this.mm_tokenizer.lineno(), ";", "number " + String.valueOf(this.mm_tokenizer.nval));
                }
                case -1: {
                    throw new PolicyParserException("expected ';', found end of file");
                }
            }
            this.mm_lookahead = this.mm_tokenizer.nextToken();
        }
    }
}

