/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.policy;

import com.sap.security.core.codesecurity.policy.PermissionEntry;
import com.sap.security.core.codesecurity.policy.PersistenceAdapter;
import com.sap.security.core.codesecurity.policy.PersistenceAdapterException;
import com.sap.security.core.codesecurity.policy.PolicyDBException;
import com.sap.security.core.codesecurity.policy.PropertyReplacer;
import com.sap.security.core.codesecurity.policy.ProtectionDomainEntry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

public class PolicyDBConnector
extends PersistenceAdapter {
    public PolicyDBConnector() {
    }

    public PolicyDBConnector(boolean flag) {
        super(flag);
    }

    public void initAdapterImpl() throws PersistenceAdapterException {
        String dburl = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dburl");
        String dbuser = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dbuser", "sa");
        String dbpass = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dbpass", "");
        String policyname = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.policyname", "default");
        Connection con = null;
        try {
            con = DriverManager.getConnection(dburl, dbuser, dbpass);
        }
        catch (SQLException sqle) {
            throw new PolicyDBException("could not connect to policy datebase: " + sqle.getMessage());
        }
        try {
            PreparedStatement codeBaseStmt = con.prepareStatement("SELECT DISTINCT CODEBASE, SIGNER FROM PORTALCODEPERMISSION WHERE POLICYNAME = ? ORDER BY CODEBASE, SIGNER");
            codeBaseStmt.setString(1, policyname);
            ResultSet codeBaseRs = codeBaseStmt.executeQuery();
            while (codeBaseRs.next()) {
                String pdecodebase = null;
                String pdesigner = null;
                String selcodebase = codeBaseRs.getString(1);
                String selsigner = codeBaseRs.getString(2);
                if (selcodebase == null || selcodebase.trim().length() == 0) {
                    pdecodebase = null;
                    selcodebase = "";
                } else {
                    pdecodebase = selcodebase.trim();
                }
                if (selsigner == null || selsigner.trim().length() == 0) {
                    pdesigner = null;
                    selsigner = "";
                } else {
                    pdesigner = selsigner.trim();
                }
                try {
                    pdesigner = this.replaceProps(pdesigner);
                    pdecodebase = this.replaceProps(pdecodebase);
                }
                catch (PropertyReplacer.PropertyReplacerException pe) {
                    throw new PolicyDBException(pe.getMessage());
                }
                ProtectionDomainEntry pde = new ProtectionDomainEntry(pdesigner, pdecodebase);
                PreparedStatement permissionsStmt = con.prepareStatement("SELECT PERMISSION, NAME, ACTION FROM PORTALCODEPERMISSION WHERE POLICYNAME = ? AND       CODEBASE = ? AND       SIGNER = ? ORDER BY CODEBASE, SIGNER");
                permissionsStmt.setString(1, policyname);
                permissionsStmt.setString(2, selcodebase);
                permissionsStmt.setString(3, selsigner);
                ResultSet permissionsRs = permissionsStmt.executeQuery();
                while (permissionsRs.next()) {
                    String permission = permissionsRs.getString(1).trim();
                    String name = permissionsRs.getString(2);
                    String action = permissionsRs.getString(3);
                    if (name != null && (name = name.trim()).length() == 0) {
                        name = null;
                    }
                    if (action != null && (action = action.trim()).length() == 0) {
                        action = null;
                    }
                    try {
                        name = this.replaceProps(name);
                        action = this.replaceProps(action);
                    }
                    catch (PropertyReplacer.PropertyReplacerException pe) {
                        throw new PolicyDBException(pe.getMessage());
                    }
                    PermissionEntry pe = new PermissionEntry(permission, name, action);
                    pde.add(pe);
                }
                this.add(pde);
            }
            PreparedStatement keystoreStmt = con.prepareStatement("SELECT KEYSTOREURL, KEYSTORETYPE FROM PORTALKEYSTORE WHERE POLICYNAME = ?");
            keystoreStmt.setString(1, policyname);
            ResultSet keystoreRs = keystoreStmt.executeQuery();
            boolean enough = false;
            while (!enough && keystoreRs.next()) {
                String keystoreurl = keystoreRs.getString(1).trim();
                String keystoretype = keystoreRs.getString(2);
                if (keystoretype != null && (keystoretype = keystoretype.trim()).length() == 0) {
                    keystoretype = null;
                }
                this.mm_keystore.mm_keyStoreUrlString = keystoreurl;
                this.mm_keystore.mm_keyStoreType = keystoretype;
                enough = true;
            }
            if (enough && keystoreRs.next()) {
                throw new PolicyDBException("too many keystore entries");
            }
        }
        catch (SQLException sqle) {
            throw new PolicyDBException("read data from policy datebase: " + sqle.getMessage());
        }
    }

    protected void upload(String policyName) throws PersistenceAdapterException {
        String dburl = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dburl");
        String dbuser = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dbuser", "sa");
        String dbpass = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.dbpass", "");
        Connection con = null;
        try {
            con = DriverManager.getConnection(dburl, dbuser, dbpass);
        }
        catch (SQLException sqle) {
            throw new PolicyDBException("could not connect to policy datebase: " + sqle.getMessage());
        }
        try {
            PreparedStatement deleteStmt = con.prepareStatement("DELETE FROM PORTALCODEPERMISSION WHERE POLICYNAME = ?");
            deleteStmt.setString(1, policyName);
            deleteStmt.executeUpdate();
            PreparedStatement deleteKeystoreStmt = con.prepareStatement("DELETE FROM PORTALKEYSTORE WHERE POLICYNAME = ?");
            deleteKeystoreStmt.setString(1, policyName);
            deleteKeystoreStmt.executeUpdate();
            if (this.mm_keystore.isEmpty() && this.mm_pdEntries.size() == 0) {
                con.commit();
                return;
            }
            PreparedStatement insertStmt = con.prepareStatement("INSERT INTO PORTALCODEPERMISSION VALUES ( ?, ?, ?, ?, ?, ? )");
            insertStmt.setString(1, policyName);
            Enumeration pdenum = this.mm_pdEntries.elements();
            while (pdenum.hasMoreElements()) {
                ProtectionDomainEntry pditem = (ProtectionDomainEntry)pdenum.nextElement();
                insertStmt.setString(2, pditem.mm_codeBase == null ? " " : pditem.mm_codeBase);
                insertStmt.setString(3, pditem.mm_signedBy == null ? " " : pditem.mm_signedBy);
                if (pditem.mm_permissionEntries == null || pditem.mm_permissionEntries.size() == 0) {
                    insertStmt.setString(4, " ");
                    insertStmt.setString(5, " ");
                    insertStmt.setString(6, " ");
                    insertStmt.executeUpdate();
                    continue;
                }
                Enumeration grenum = pditem.mm_permissionEntries.elements();
                while (grenum.hasMoreElements()) {
                    PermissionEntry peritem = (PermissionEntry)grenum.nextElement();
                    insertStmt.setString(4, peritem.mm_permissiontype);
                    insertStmt.setString(5, peritem.mm_name == null ? " " : peritem.mm_name);
                    insertStmt.setString(6, peritem.mm_action == null ? " " : peritem.mm_action);
                    insertStmt.executeUpdate();
                }
            }
            if (!this.mm_keystore.isEmpty()) {
                PreparedStatement insertKeystoreStmt = con.prepareStatement("INSERT INTO PORTALKEYSTORE VALUES ( ?, ?, ? )");
                insertKeystoreStmt.setString(1, policyName);
                insertKeystoreStmt.setString(2, this.mm_keystore.mm_keyStoreUrlString == null ? " " : this.mm_keystore.mm_keyStoreUrlString);
                insertKeystoreStmt.setString(3, this.mm_keystore.mm_keyStoreType == null ? " " : this.mm_keystore.mm_keyStoreType);
                insertKeystoreStmt.executeUpdate();
            }
            con.commit();
        }
        catch (SQLException sqle) {
            throw new PolicyDBException("could not upload policy: " + sqle.getMessage());
        }
    }
}

