/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.policy;

import com.sap.security.core.codesecurity.policy.KeyStoreEntry;
import com.sap.security.core.codesecurity.policy.PersistenceAdapterException;
import com.sap.security.core.codesecurity.policy.PolicyDBConnector;
import com.sap.security.core.codesecurity.policy.PolicyFileParser;
import com.sap.security.core.codesecurity.policy.PropertyReplacer;
import com.sap.security.core.codesecurity.policy.ProtectionDomainEntry;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class PersistenceAdapter {
    private static PersistenceAdapter theAdapter = null;
    public static final String ADAPTERFILE = "fileadapter";
    public static final String ADAPTERDATABASE = "databaseadapter";
    protected Vector mm_pdEntries;
    protected boolean mm_replaceProp;
    protected KeyStoreEntry mm_keystore;
    static /* synthetic */ Class class$com$sap$security$core$codesecurity$policy$PersistenceAdapter;

    public static void main(String[] args) throws Exception {
        if (args.length != 2 || args[0].length() == 0 || args[1].length() == 0) {
            System.err.println("usage: java... " + (class$com$sap$security$core$codesecurity$policy$PersistenceAdapter == null ? (class$com$sap$security$core$codesecurity$policy$PersistenceAdapter = PersistenceAdapter.class$("com.sap.security.core.codesecurity.policy.PersistenceAdapter")) : class$com$sap$security$core$codesecurity$policy$PersistenceAdapter).getName() + " <policyfile> <policyname>!");
            return;
        }
        System.out.println("start uploading policy file " + args[0] + " with policyname \"" + args[1] + "\"...");
        System.setProperty("java.security.policy", args[0]);
        try {
            PolicyFileParser inFileAdapter = new PolicyFileParser(false);
            PolicyDBConnector outDBAdapter = new PolicyDBConnector(false);
            ((PersistenceAdapter)inFileAdapter).initAdapterImpl();
            System.out.println("policy file at " + args[0] + " read successfully...");
            outDBAdapter.mm_keystore = inFileAdapter.mm_keystore;
            outDBAdapter.mm_pdEntries = inFileAdapter.mm_pdEntries;
            ((PersistenceAdapter)outDBAdapter).upload(args[1]);
            System.out.println("finished uploading policy file " + args[0] + " with policyname \"" + args[1] + "\"!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final PersistenceAdapter getPersistenceAdapter(boolean reload) throws PersistenceAdapterException {
        boolean exprops;
        if (reload) {
            theAdapter = null;
        }
        if (theAdapter != null) {
            return theAdapter;
        }
        String adapter = PersistenceAdapter.getPropertyPrivileged("com.sap.security.policy.adapter", ADAPTERFILE);
        String propexprops = Security.getProperty("policy.expandProperties");
        boolean bl = exprops = propexprops == null ? false : propexprops.equalsIgnoreCase("true");
        if (adapter.equalsIgnoreCase(ADAPTERFILE)) {
            theAdapter = new PolicyFileParser(exprops);
        }
        if (adapter.equalsIgnoreCase(ADAPTERDATABASE)) {
            theAdapter = new PolicyDBConnector(exprops);
        }
        if (theAdapter != null) {
            theAdapter.initAdapterImpl();
            return theAdapter;
        }
        throw new PersistenceAdapterException((class$com$sap$security$core$codesecurity$policy$PersistenceAdapter == null ? (class$com$sap$security$core$codesecurity$policy$PersistenceAdapter = PersistenceAdapter.class$("com.sap.security.core.codesecurity.policy.PersistenceAdapter")) : class$com$sap$security$core$codesecurity$policy$PersistenceAdapter).getName() + ": requested adapter null or not known");
    }

    protected PersistenceAdapter() {
        this(false);
    }

    protected PersistenceAdapter(boolean flag) {
        this.mm_replaceProp = flag;
        this.mm_pdEntries = new Vector();
        this.mm_keystore = new KeyStoreEntry(flag);
    }

    public final Enumeration protectionDomainElements() {
        return this.mm_pdEntries.elements();
    }

    public final void add(ProtectionDomainEntry pdEntry) {
        this.mm_pdEntries.addElement(pdEntry);
    }

    public final void replace(ProtectionDomainEntry pdNew, ProtectionDomainEntry pdOld) {
        this.mm_pdEntries.setElementAt(pdNew, this.mm_pdEntries.indexOf(pdOld));
    }

    public final boolean remove(ProtectionDomainEntry pdEntry) {
        return this.mm_pdEntries.removeElement(pdEntry);
    }

    public final KeyStoreEntry getKeyStore() {
        return this.mm_keystore;
    }

    public final void setKeyStore(KeyStoreEntry keystore) {
        this.mm_keystore = keystore;
    }

    public final void print(Writer writer) {
        PrintWriter printwriter = new PrintWriter(new BufferedWriter(writer));
        Enumeration enumeration = this.protectionDomainElements();
        printwriter.println("/**");
        printwriter.println(" * AUTOMATICALLY GENERATED ON " + new Date());
        printwriter.println(" * by " + this.getClass().getName());
        printwriter.println(" * DO NOT EDIT");
        printwriter.println(" */");
        printwriter.println();
        this.mm_keystore.print(printwriter);
        while (enumeration.hasMoreElements()) {
            ProtectionDomainEntry pdentry = (ProtectionDomainEntry)enumeration.nextElement();
            pdentry.print(printwriter);
            printwriter.println();
        }
        printwriter.flush();
    }

    protected static final String getPropertyPrivileged(final String key, final String defaultval) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(key, defaultval);
            }
        });
    }

    protected static final String getPropertyPrivileged(final String key) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(key);
            }
        });
    }

    protected String replaceProps(String stringwithprops) throws PropertyReplacer.PropertyReplacerException {
        if (this.mm_replaceProp) {
            return PropertyReplacer.replace(stringwithprops);
        }
        return stringwithprops;
    }

    protected abstract void initAdapterImpl() throws PersistenceAdapterException;

    protected abstract void upload(String var1) throws PersistenceAdapterException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

