/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.permission;

import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermissionCollection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

class ProtectedCallPermissionCollection
extends PermissionCollection {
    private Hashtable table = new Hashtable(10);
    private static final String WILDCARD = "*";
    private static final String CRYPTOSERVICENAME = "com.sapportals.portal.prt.service.security.IDummyService";
    private static final String DISPATCHER = "com.sapportals.portal.prt.dispatcher.Dispatcher$doService";
    private static HashSet allowedStackEntries = new HashSet(10);

    ProtectedCallPermissionCollection() {
    }

    public void add(Permission permission) {
        if (!(permission instanceof ProtectedCallPermission)) {
            return;
        }
        Permission pp = (Permission)this.table.get(permission.getName());
        if (pp == null) {
            this.table.put(permission.getName(), permission);
        } else if (permission.implies(pp)) {
            this.table.put(permission.getName(), permission);
        } else if (!pp.implies(permission)) {
            String actions1 = pp.getActions();
            String actions2 = permission.getActions();
            StringTokenizer st1 = new StringTokenizer(actions1, ",");
            StringTokenizer st2 = new StringTokenizer(actions2, ",");
            HashSet<String> v = new HashSet<String>(10);
            while (st1.hasMoreElements()) {
                v.add(st1.nextToken());
            }
            while (st2.hasMoreElements()) {
                v.add(st2.nextToken());
            }
            StringBuffer newAction = new StringBuffer("");
            Iterator it = v.iterator();
            while (it.hasNext()) {
                newAction.append(it.next());
                newAction.append(',');
            }
            newAction.deleteCharAt(newAction.length() - 1);
            permission = new ProtectedCallPermission(permission.getName(), newAction.toString());
            this.table.put(permission.getName(), permission);
        }
    }

    public boolean implies(Permission permission) {
        boolean implied;
        if (!(permission instanceof ProtectedCallPermission)) {
            return false;
        }
        String permName = permission.getName();
        Permission p = (Permission)this.table.get(permName);
        boolean bl = implied = p == null ? false : p.implies(permission);
        if (!implied) {
            p = (Permission)this.table.get(WILDCARD);
            boolean bl2 = implied = p == null ? false : p.implies(permission);
        }
        if (!implied) {
            return false;
        }
        if (permName.equalsIgnoreCase(CRYPTOSERVICENAME)) {
            return this.callStackOkay();
        }
        return true;
    }

    private boolean callStackOkay() {
        class StackCheckSecurityManager
        extends SecurityManager {
            private final /* synthetic */ ProtectedCallPermissionCollection this$0;

            StackCheckSecurityManager(ProtectedCallPermissionCollection this$0) {
                this.this$0 = this$0;
            }

            public Class[] getCallStack() {
                return this.getClassContext();
            }
        }
        class DoGetSecurityManager
        implements PrivilegedAction {
            private final /* synthetic */ ProtectedCallPermissionCollection this$0;

            DoGetSecurityManager(ProtectedCallPermissionCollection this$0) {
                this.this$0 = this$0;
            }

            public Object run() {
                return new StackCheckSecurityManager(this.this$0);
            }
        }
        StackCheckSecurityManager secman = (StackCheckSecurityManager)AccessController.doPrivileged(new DoGetSecurityManager(this));
        Class[] callstack = secman.getCallStack();
        int i = 0;
        while (i < callstack.length) {
            String className = callstack[i].getName();
            if (className.equals(DISPATCHER)) {
                return true;
            }
            if (!allowedStackEntries.contains(className)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    static {
        allowedStackEntries.add("com.sap.security.core.codesecurity.permission.ProtectedCallPermissionCollection");
        allowedStackEntries.add("com.sap.security.core.codesecurity.permission.ProtectedCallPermissionCollection$1$StackCheckSecurityManager");
        allowedStackEntries.add("com.sapportals.portal.prt.service.security.SecurityService");
        allowedStackEntries.add("com.sap.test.SAPComponent");
        allowedStackEntries.add("com.sapportals.portal.prt.component.AbstractPortalComponent");
        allowedStackEntries.add("com.sapportals.portal.prt.core.PortalRequestManager");
        allowedStackEntries.add("com.sapportals.portal.prt.component.PortalComponentResponse");
        allowedStackEntries.add("com.sapportals.portal.prt.pom.PortalNode");
        allowedStackEntries.add("com.sapportals.portal.prt.service.prtconnection.ServletConnection");
    }
}

