/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.codesecurity.permission;

import com.sap.security.core.codesecurity.permission.ProtectedCallPermissionCollection;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ProtectedCallPermission
extends BasicPermission {
    private static final String WILDCARD = "*";
    private HashSet actions = new HashSet();

    public ProtectedCallPermission(String class_name) {
        this(class_name, WILDCARD);
    }

    public ProtectedCallPermission(String class_name, String method_names) {
        super(class_name.trim(), null);
        String mn;
        String string = mn = class_name.trim().equalsIgnoreCase(WILDCARD) ? WILDCARD : method_names.trim();
        if (mn.equalsIgnoreCase(WILDCARD)) {
            this.actions.add(WILDCARD);
            return;
        }
        StringTokenizer st = new StringTokenizer(method_names, ",");
        while (st.hasMoreElements()) {
            this.actions.add(st.nextToken().trim());
        }
    }

    public String getActions() {
        if (this.actions.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.actions.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            buf.append(',');
        }
        return buf.substring(0, buf.length() - 1);
    }

    public boolean implies(Permission aPermission) {
        if (!(aPermission instanceof ProtectedCallPermission)) {
            return false;
        }
        ProtectedCallPermission permission = (ProtectedCallPermission)aPermission;
        String myName = this.getName();
        if (!myName.equals(WILDCARD) && !myName.equals(permission.getName())) {
            return false;
        }
        if (WILDCARD.equals(this.getActions())) {
            return true;
        }
        Iterator ii = permission.actions.iterator();
        while (ii.hasNext()) {
            if (this.actions.contains(ii.next())) continue;
            return false;
        }
        return true;
    }

    public PermissionCollection newPermissionCollection() {
        return new ProtectedCallPermissionCollection();
    }

    public String toString() {
        return '(' + this.getClass().getName() + ' ' + this.getName() + ' ' + this.getActions() + ')';
    }
}

