/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.plugin.audit;

import com.togethersoft.sca.ast.AstArrayCreationExpression;
import com.togethersoft.sca.ast.AstArrayInitializer;
import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstConditionalExpression;
import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstContinueStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstEmptyStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSuperExpression;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstSynchronizedStatement;
import com.togethersoft.sca.ast.AstThisExpression;
import com.togethersoft.sca.ast.AstThrowStatement;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.IField;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.ITupleSet;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.IAuditRule;
import java.util.ResourceBundle;

public class AuditRule
implements IAuditRule {
    private DataFlowAnalyzer dataFlowAnalyzer;
    private IProject project;
    private IAnalyzerDescriptor analyzer;
    private String severity;
    private int group;
    private ReportManager logger;

    public static String getAutoFixName(String id) {
        return Audit.getResourceBundle().getString(id);
    }

    public static String getAutoFixName(IAuditMessage m) {
        return Audit.getResourceBundle().getString("Audit" + m.getAnalyzer().getId() + ".Autofix");
    }

    public static String getAutoFixName(IAuditMessage m, int fixNo) {
        return Audit.getResourceBundle().getString("Audit" + m.getAnalyzer().getId() + ".Autofix." + fixNo);
    }

    public AuditRule(int group) {
        this.group = group;
    }

    public boolean requiresDataFlowAnalysis() {
        return false;
    }

    public AutoFix getSuppressionFix(final IAuditMessage msg) {
        final String suppresComment = "//$SUP-" + msg.getAnalyzer().getId() + "$";
        if (ESAutoFix.enabled) {
            AstObject stmt = msg.getAstObject();
            AstSourcePosition pos = stmt.getPosition();
            if (pos != null && pos.getStartColumn() != 0) {
                ESAutoFix fix = new ESAutoFix(AuditRule.getAutoFixName("SuppressionAutofix"));
                fix.setTabSize(this.getProject().getTabSize());
                fix.insertLine(pos, suppresComment);
                fix.indent(pos.getStartColumn());
                return fix;
            }
            return null;
        }
        return new ASTAutoFix("SuppressionAutofix"){

            public boolean fix() {
                AstObject stmt = msg.getAstObject();
                AstObjectFactory factory = Factory.getObjectFactory();
                AstComment comment = factory.createAstComment(suppresComment + "\n");
                comment.setPosition(stmt.getPosition());
                stmt.addComment(comment);
                return true;
            }
        };
    }

    public DataFlowAnalyzer getDataFlowAnalyzer() {
        return this.dataFlowAnalyzer;
    }

    public void setDataFlowAnalyzer(DataFlowAnalyzer dataFlowAnalyzer) {
        this.dataFlowAnalyzer = dataFlowAnalyzer;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        this.analyzer = analyzer;
        this.severity = severity;
        this.logger = logger;
    }

    public IAnalyzerDescriptor getAnalyzer() {
        return this.analyzer;
    }

    public String getSeverity() {
        return this.severity;
    }

    public int getGroup() {
        return this.group;
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    protected IAuditMessage message(AstObject element) {
        return this.logger.message(this, element, this.getAnalyzer().getName(), null);
    }

    protected IAuditMessage message(AstObject element, Object[] values) {
        return this.logger.message(this, element, this.getAnalyzer().getName(), values);
    }

    protected IAuditMessage message(IAuditMessage parentMessage, AstObject element) {
        return this.logger.message(this, parentMessage, element, this.getAnalyzer().getName(), null);
    }

    protected IAuditMessage message(AstObject element, String msg, Object[] values) {
        return this.logger.message(this, element, msg, values);
    }

    protected IAuditMessage message(IAuditMessage parentMessage, AstObject element, String msg, Object[] values) {
        return this.logger.message(this, parentMessage, element, msg, values);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
    }

    public void checkBasicBlock(IBasicBlock block) {
    }

    public void checkLoop(IJavaLoop loop) {
    }

    public void checkField(IField field, AstField ast) {
    }

    public void checkMethod(IMethod method, AstMethod ast) {
    }

    public void checkLifetime(ITupleSet[][] webs) {
    }

    public void checkDeclaration(AstDeclaration decl) {
    }

    public void enterPackage(AstPackage pkg) {
    }

    public void leavePackage(AstPackage pkg) {
    }

    public void checkCompilationUnit(AstCompilationUnit decl) {
        this.checkDeclaration((AstDeclaration)decl);
    }

    public void checkModel(AstModel model) {
    }

    public void checkType(AstType decl) {
        this.checkDeclaration((AstDeclaration)decl);
    }

    public void checkMethod(AstMethod method) {
        this.checkDeclaration((AstDeclaration)method);
    }

    public void leaveMethod(AstMethod method) {
    }

    public void checkInitializer(AstInitializer init) {
        this.checkDeclaration((AstDeclaration)init);
    }

    public void checkField(AstField field) {
        this.checkDeclaration((AstDeclaration)field);
    }

    public void checkVariable(AstVariable decl) {
    }

    public void checkExpression(AstExpression expr) {
    }

    public void checkArrayCreationExpression(AstArrayCreationExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkArrayInitializer(AstArrayInitializer expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkArrayReference(AstArrayReference expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkAssignmentExpression(AstAssignmentExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkBinaryExpression(AstBinaryExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkCastExpression(AstCastExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkConditionalExpression(AstConditionalExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkConstructorInvocation(AstConstructorInvocation expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkFieldReference(AstFieldReference expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkLiteral(AstLiteral expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkMethodCallExpression(AstMethodCallExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkObjectCreationExpression(AstObjectCreationExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkParenthesizedExpression(AstParenthesizedExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkSimpleReference(AstSimpleReference expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkSuperExpression(AstSuperExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkThisExpression(AstThisExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkTypeExpression(AstTypeExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkUnaryExpression(AstUnaryExpression expr) {
        this.checkExpression((AstExpression)expr);
    }

    public void checkStatement(AstStatement stmt) {
    }

    public void checkAssertStatement(AstAssertStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkBreakStatement(AstBreakStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkCompoundStatement(AstCompoundStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void leaveCompoundStatement(AstCompoundStatement stmt) {
    }

    public void checkContinueStatement(AstContinueStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkDeclarationStatement(AstDeclarationStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkDoStatement(AstDoStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkEmptyStatement(AstEmptyStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkExpressionStatement(AstExpressionStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkForStatement(AstForStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkIfStatement(AstIfStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkReturnStatement(AstReturnStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkSwitchStatement(AstSwitchStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkSynchronizedStatement(AstSynchronizedStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkThrowStatement(AstThrowStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkTryStatement(AstTryStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public void checkWhileStatement(AstWhileStatement stmt) {
        this.checkStatement((AstStatement)stmt);
    }

    public String getExplainMessage(AstObject ast, String messageId, Object[] values) {
        String tmplFileName = this.analyzer.getImplementation();
        tmplFileName = "builtin".equals(tmplFileName) ? "com.togethersoft.sca.internal.plugin.audit." : tmplFileName.substring(0, tmplFileName.lastIndexOf(".") + 1);
        tmplFileName = tmplFileName + (this.analyzer.getName().equals(messageId) ? this.analyzer.getId() : messageId.replace('.', '_'));
        return this.getExplainMessage(tmplFileName, ast, messageId, values);
    }

    protected String getExplainMessage(String tmplFileName, AstObject ast, String messageId, Object[] values) {
        return Audit.getTemplateManager().formatTemplateFile(tmplFileName, Audit.getClassLoader(), values);
    }

    protected boolean isMethodOverridable(AstMethod method) {
        switch (Audit.getScope()) {
            case 0: {
                return !method.isPrivate();
            }
            case 1: {
                if (method.isPrivate()) {
                    return false;
                }
                if (method.isPublic() || method.isProtected()) {
                    return true;
                }
                AstMethod[] overriders = method.overriddenBy();
                int i = 0;
                while (i < overriders.length) {
                    if (overriders[i].isPublic() || overriders[i].isProtected()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return false;
    }
}

