/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;

public class VertexList {
    private GraphVertex[] arr = new GraphVertex[8];
    private int used = 0;
    private GraphVertex[] cachedValue;

    public void set(GraphVertex[] a) {
        this.arr = a;
        this.used = a.length;
    }

    public final int size() {
        return this.used;
    }

    public final boolean empty() {
        return this.used == 0;
    }

    public final void clear() {
        this.cachedValue = null;
        this.used = 0;
    }

    public final boolean equalsToArray(GraphVertex[] a) {
        if (this.used != a.length) {
            return false;
        }
        GraphVertex[] b = this.arr;
        int i = this.used;
        while (--i >= 0) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public final void intersect(GraphVertex[] a) {
        int i = this.used;
        while (--i >= 0) {
            int j = a.length;
            while (--j >= 0) {
                if (this.arr[i] == a[j]) break;
            }
            if (j >= 0) continue;
            this.remove(i);
        }
    }

    public final boolean emptyIntersectionWith(GraphVertex[] a) {
        GraphVertex[] b = this.arr;
        int i = this.used;
        while (--i >= 0) {
            int j = a.length;
            while (--j >= 0) {
                if (b[i] != a[j]) continue;
                return false;
            }
        }
        return true;
    }

    public final void remove(int pos) {
        int i = pos;
        int n = this.used - 1;
        while (i < n) {
            this.arr[i] = this.arr[i + 1];
            ++i;
        }
        --this.used;
    }

    public final void push(GraphVertex v) {
        this.cachedValue = null;
        if (this.used == this.arr.length) {
            GraphVertex[] newArr = new GraphVertex[this.used * 2];
            System.arraycopy(this.arr, 0, newArr, 0, this.used);
            this.arr = newArr;
        }
        this.arr[this.used++] = v;
    }

    public final GraphVertex pop() {
        this.cachedValue = null;
        return this.arr[--this.used];
    }

    public final GraphVertex top() {
        return this.arr[this.used - 1];
    }

    public GraphVertex[] toArray() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        GraphVertex[] a = new GraphVertex[this.used];
        System.arraycopy(this.arr, 0, a, 0, this.used);
        this.cachedValue = a;
        return a;
    }
}

