/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.sync.CallContext;
import com.togethersoft.sca.internal.plugin.audit.sync.CalleeDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.ClassDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;
import com.togethersoft.sca.internal.plugin.audit.sync.VertexList;
import java.util.ArrayList;

public class MethodDesc
implements Comparable {
    AstMethod method;
    CalleeDesc callees;
    MethodDesc next;
    CallContext proceededStates;
    public GraphVertex syncObject;
    public ClassDesc cls;
    public int attr;
    public AstObject[] syncExpr;
    public GraphVertex[] topLevelSyncBlocks;
    public MethodDesc nextEntryPoint;
    public static MethodDesc entryPointList;
    static ArrayList entryPointsDefinitions;
    public static final int M_WAIT = 65536;
    public static final int M_SERIALIZED = 131072;
    public static final int M_CONCURRENT = 262144;
    public static final int M_VISITED = 524288;
    public static final int M_DEADLOCK_FREE = 0x100000;
    public static final int M_OVERRIDE = 0x200000;

    public final boolean isConstructor() {
        return this.method.isConstructor();
    }

    public static void cleanup() {
        entryPointList = null;
    }

    public MethodDesc(MethodDesc next, ClassDesc cls, AstMethod method) {
        this.next = next;
        this.cls = cls;
        this.method = method;
    }

    public void addState(CallContext cc) {
        cc.next = this.proceededStates;
        this.proceededStates = cc;
    }

    public int compareTo(Object o) {
        return this.method.getQualifiedName().compareTo(((MethodDesc)o).method.getQualifiedName());
    }

    public void addCallee(MethodDesc method, int attr, AstExpression callExpr, VertexList monitors) {
        this.callees = new CalleeDesc(this.callees, this.cls, method, attr, callExpr, monitors);
    }

    private boolean isProceeded(CallContext cc) {
        CallContext state = this.proceededStates;
        while (state != null) {
            if (state.equalState(cc)) {
                return true;
            }
            state = state.next;
        }
        return false;
    }

    boolean isOverride() {
        return (this.attr & 0x200000) != 0;
    }

    void calculateAttributes() {
        CalleeDesc callee = this.callees;
        while (callee != null) {
            if ((this.method.getModifiers() & callee.method.method.getModifiers() & 8) != 0 && this.cls.cls.isDerivedFrom(callee.method.cls.cls)) {
                callee.attr |= 1;
            }
            callee = callee.next;
        }
        AstType cls = this.method.getDeclaringType();
        if (Audit.allPublicReentrant && this.method.isPublic()) {
            this.nextEntryPoint = entryPointList;
            entryPointList = this;
        } else {
            int i = entryPointsDefinitions.size();
            while (--i >= 0) {
                EntryPoint ep = (EntryPoint)entryPointsDefinitions.get(i);
                if (!ep.overriddenMethodName.equals(this.method.getElementName()) || !ep.overriddenMethodSignature.equals(this.method.getSignature()) || !cls.isDerivedFrom(ep.baseClassName)) continue;
                this.nextEntryPoint = entryPointList;
                entryPointList = this;
                break;
            }
        }
    }

    void addOverriddenMethodInvocations() {
        CalleeDesc inv = this.callees;
        while (inv != null) {
            if ((inv.attr & 8) == 0 && (Audit.overrideAlienMethods || inv.method.method.getDeclaringType().isSource())) {
                AstMethod[] overridden = inv.method.method.overriddenBy();
                int i = 0;
                while (i < overridden.length) {
                    if ((overridden[i].getModifiers() & 0x600) == 0) {
                        this.callees = new CalleeDesc(this.callees, this.cls, Audit.getMethod(overridden[i]), inv);
                    }
                    ++i;
                }
            }
            inv = inv.next;
        }
    }

    public void buildConcurrentClosure() {
        CallContext nextLevel;
        CalleeDesc thisInvocation;
        CallContext.entryPoint.inv = thisInvocation = new CalleeDesc(this);
        CallContext thisLevel = CallContext.entryPoint;
        do {
            nextLevel = null;
            CallContext cc = thisLevel;
            while (cc != null) {
                MethodDesc mth = cc.inv.method;
                if (cc.monitors.length != 0 && mth.topLevelSyncBlocks != null) {
                    int i = mth.topLevelSyncBlocks.length;
                    while (--i >= 0) {
                        int j = cc.monitors.length;
                        while (--j >= 0 && mth.topLevelSyncBlocks[i] != cc.monitors[j]) {
                        }
                        if (j >= 0) continue;
                        cc.monitors[cc.monitors.length - 1].addEdge(mth.topLevelSyncBlocks[i], mth.syncExpr[i], cc);
                    }
                }
                CalleeDesc inv = mth.callees;
                while (inv != null) {
                    CallContext cc1 = new CallContext(cc, nextLevel, inv);
                    if (!inv.method.isProceeded(cc1)) {
                        inv.method.addState(cc1);
                        nextLevel = cc1;
                    }
                    inv = inv.next;
                }
                cc = cc.breadthFirst;
            }
            while (thisLevel != null) {
                CallContext nextSibling = thisLevel.breadthFirst;
                thisLevel.breadthFirst = null;
                thisLevel = nextSibling;
            }
        } while ((thisLevel = nextLevel) != null);
        CallContext.entryPoint.inv = null;
    }

    static {
        entryPointsDefinitions = new ArrayList();
        entryPointsDefinitions.add(new EntryPoint("java/lang/Runnable", "run", "()V"));
        entryPointsDefinitions.add(new EntryPoint("java/lang/Thread", "run", "()V"));
        entryPointsDefinitions.add(new EntryPoint("javax/servlet/Servlet", "service", "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V"));
    }

    static class EntryPoint {
        String baseClassName;
        String overriddenMethodName;
        String overriddenMethodSignature;

        EntryPoint(String baseClassName, String overriddenMethodName, String overriddenMethodSignature) {
            this.baseClassName = baseClassName;
            this.overriddenMethodName = overriddenMethodName;
            this.overriddenMethodSignature = overriddenMethodSignature;
        }
    }
}

