/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.sync.CallContext;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphEdge;

public class GraphVertex {
    GraphEdge edges;
    GraphVertex next = graph;
    GraphVertex pred;
    GraphEdge backEdge;
    GraphVertex breadthFirst;
    int marker = 0;
    public static GraphVertex graph;

    public static void verify() {
        int nLoops = 0;
        int marker = 1;
        GraphVertex root = graph;
        while (root != null) {
            GraphVertex nextLevel;
            root.breadthFirst = null;
            root.marker = marker;
            boolean loopFound = false;
            GraphVertex thisLevel = root;
            do {
                nextLevel = null;
                GraphVertex v = thisLevel;
                while (v != null) {
                    GraphEdge e = v.edges;
                    while (e != null) {
                        GraphVertex ev = e.vertex;
                        if (ev == root) {
                            long mask = e.mask;
                            GraphVertex p = v;
                            while (p != root) {
                                mask &= p.backEdge.mask;
                                p = p.pred;
                            }
                            loopFound = true;
                            if (mask == 0L) {
                                IAuditMessage msg = Audit.message(5, e.expr, "AuditSync.4", new Object[]{new Integer(++nLoops)});
                                e.message(nLoops, msg);
                                p = v;
                                while (p != root) {
                                    p.backEdge.message(nLoops, msg);
                                    p = p.pred;
                                }
                            }
                        } else if (ev.marker != marker) {
                            ev.pred = v;
                            ev.marker = marker;
                            ev.breadthFirst = nextLevel;
                            nextLevel = ev;
                            ev.backEdge = e;
                        }
                        e = e.next;
                    }
                    v = v.breadthFirst;
                }
            } while ((thisLevel = nextLevel) != null && (!loopFound || Audit.reportAllLoops));
            ++marker;
            root = root.next;
        }
    }

    public void addEdge(GraphVertex vertex, AstObject expr, CallContext cc) {
        GraphEdge edge = this.edges;
        while (edge != null) {
            if (!(edge.vertex != vertex || edge.expr != expr || Audit.reportAllLoops && edge.callCtx.inv != cc.inv)) {
                return;
            }
            edge = edge.next;
        }
        this.edges = new GraphEdge(vertex, expr, this.edges, cc);
    }

    public GraphVertex() {
        graph = this;
        this.edges = null;
    }
}

