/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.sync.CallContext;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;

public class GraphEdge {
    GraphEdge next;
    AstObject expr;
    GraphVertex vertex;
    CallContext callCtx;
    long mask;

    public GraphEdge(GraphVertex vertex, AstObject expr, GraphEdge sibling, CallContext cc) {
        this.next = sibling;
        this.callCtx = cc;
        this.mask = 0L;
        this.expr = expr;
        this.vertex = vertex;
    }

    void dump() {
        if (this.callCtx.inv != null) {
            System.out.println(this.callCtx.inv.selfClass.cls.getQualifiedName() + ":" + this.callCtx.inv.callExpr.getPosition().getStartLine() + "->" + this.expr.getPosition().getFileName() + ":" + this.expr.getPosition().getStartLine());
        } else {
            System.out.println("->" + this.expr.getPosition().getFileName() + ":" + this.expr.getPosition().getStartLine());
        }
    }

    void message(int loopId, IAuditMessage loopMsg) {
        this.mask |= 1L << (loopId & 0x3F);
        IAuditMessage imsg = Audit.message(5, loopMsg, this.expr, "AuditSync.2", new Object[]{new Integer(loopId)});
        CallContext cc = this.callCtx;
        while (cc.inv != null) {
            Audit.message(5, imsg, (AstObject)cc.inv.callExpr, "AuditSync.3", new Object[]{new Integer(loopId), cc.inv.method.method});
            cc = cc.up;
        }
    }
}

