/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.sync.AccessDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.CallContext;
import com.togethersoft.sca.internal.plugin.audit.sync.CalleeDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.FieldDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;
import com.togethersoft.sca.internal.plugin.audit.sync.MethodDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.VertexList;

public class ClassDesc {
    MethodDesc methods;
    FieldDesc fields;
    public AstType cls;
    public ClassDesc next;
    public GraphVertex classMonitor;
    public GraphVertex metaclassMonitor;

    public ClassDesc(ClassDesc next, AstType cls) {
        this.next = next;
        this.cls = cls;
        this.classMonitor = new GraphVertex();
        this.metaclassMonitor = new GraphVertex();
    }

    public MethodDesc addMethod(AstMethod mth) {
        this.methods = new MethodDesc(this.methods, this, mth);
        return this.methods;
    }

    public MethodDesc getMethod(AstMethod key) {
        MethodDesc mth = this.methods;
        while (mth != null) {
            if (mth.method == key) {
                return mth;
            }
            mth = mth.next;
        }
        return this.addMethod(key);
    }

    public FieldDesc getField(AstVariable key) {
        FieldDesc fld = this.fields;
        while (fld != null) {
            if (fld.field == key) {
                return fld;
            }
            fld = fld.next;
        }
        return this.addField(key);
    }

    public FieldDesc addField(AstVariable key) {
        this.fields = new FieldDesc(this.fields, this, key);
        return this.fields;
    }

    public void calculateAttributes() {
        MethodDesc mth = this.methods;
        while (mth != null) {
            mth.calculateAttributes();
            mth = mth.next;
        }
    }

    public void addOverriddenMethodInvocations() {
        MethodDesc mth = this.methods;
        while (mth != null) {
            mth.addOverriddenMethodInvocations();
            mth = mth.next;
        }
    }

    private void checkInheritance(ClassDesc derived) {
        MethodDesc bm = this.methods;
        while (bm != null) {
            if (!(bm.method.isStatic() || bm.method.isFinal() || bm.method.isPrivate())) {
                MethodDesc dm = derived.methods;
                while (dm != null) {
                    if (bm.method.getElementName().equals(dm.method.getElementName()) && bm.method.getSignature().equals(dm.method.getSignature()) && !dm.isOverride()) {
                        if ((bm.method.getModifiers() & 0x20) != 0 && (dm.method.getModifiers() & 0x20) == 0) {
                            Audit.message(7, (AstObject)dm.method, "AuditSync.1", new Object[]{bm.method, derived.cls});
                        }
                        if (!this.cls.isInterface()) {
                            dm.attr |= 0x200000;
                        }
                    }
                    dm = dm.next;
                }
            }
            bm = bm.next;
        }
        if (this.cls.getSuperClass() != null) {
            Audit.getClass(this.cls.getSuperClass()).checkInheritance(derived);
        }
        AstType[] ifaces = this.cls.getSuperInterfaces();
        int i = 0;
        while (i < ifaces.length) {
            Audit.getClass(ifaces[i]).checkInheritance(derived);
            ++i;
        }
    }

    public void verify() {
        if (this.cls.getSuperClass() != null) {
            Audit.getClass(this.cls.getSuperClass()).checkInheritance(this);
        }
        AstType[] ifaces = this.cls.getSuperInterfaces();
        int i = 0;
        while (i < ifaces.length) {
            Audit.getClass(ifaces[i]).checkInheritance(this);
            ++i;
        }
    }

    public static void buildConcurrentClosure() {
        MethodDesc mth = MethodDesc.entryPointList;
        while (mth != null) {
            mth.buildConcurrentClosure();
            mth = mth.nextEntryPoint;
        }
    }

    public void findWaitsWithLockedMonitors() {
        MethodDesc mth = this.methods;
        while (mth != null) {
            CalleeDesc inv = mth.callees;
            while (inv != null) {
                if (inv.method.method.getElementName().equals("wait")) {
                    int nLocked = inv.monitors.length;
                    if (nLocked == 1) {
                        CallContext cc = inv.method.proceededStates;
                        while (cc != null) {
                            if (cc.monitors.length > 1) {
                                nLocked = 2;
                                break;
                            }
                            if (cc.monitors.length == 1 && cc.monitors[0] != inv.monitors[0]) {
                                nLocked = 2;
                                break;
                            }
                            cc = cc.next;
                        }
                    }
                    if (nLocked > 1) {
                        Audit.message(6, (AstObject)inv.callExpr);
                    }
                }
                inv = inv.next;
            }
            mth = mth.next;
        }
    }

    public void checkRaceConditions() {
        VertexList locks = new VertexList();
        FieldDesc fld = this.fields;
        while (fld != null) {
            boolean synchronizedAccess = false;
            AccessDesc acc = fld.accesses;
            while (acc != null) {
                if (acc.monitors.length > 0 && (acc.attr & 2) != 0) {
                    synchronizedAccess = true;
                    break;
                }
                acc = acc.next;
            }
            if (synchronizedAccess) {
                boolean nonSynchronizedAccess = false;
                synchronizedAccess = false;
                AccessDesc acc2 = fld.accesses;
                while (acc2 != null) {
                    if (acc2.monitors.length > 0) {
                        if (synchronizedAccess) {
                            locks.intersect(acc2.monitors);
                        } else {
                            synchronizedAccess = true;
                            locks.set(acc2.monitors);
                        }
                    } else {
                        nonSynchronizedAccess = true;
                    }
                    acc2 = acc2.next;
                }
                if (nonSynchronizedAccess || locks.empty()) {
                    IAuditMessage msg = null;
                    AccessDesc acc3 = fld.accesses;
                    while (acc3 != null) {
                        block20: {
                            if (acc3.monitors.length == 0) {
                                CallContext cc = acc3.accessor.proceededStates;
                                while (cc != null) {
                                    if (cc.monitors.length == 0) {
                                        if (msg == null) {
                                            msg = Audit.message(8, (AstObject)fld.field, "AuditSync.5", new Object[]{fld.field});
                                        }
                                        Audit.message(9, msg, acc3.ref);
                                        break block20;
                                    }
                                    cc = cc.next;
                                }
                                CallContext cc2 = acc3.accessor.proceededStates;
                                while (cc2 != null) {
                                    if (locks.emptyIntersectionWith(cc2.monitors)) {
                                        if (msg == null) {
                                            msg = Audit.message(8, (AstObject)fld.field, "AuditSync.5", new Object[]{fld.field});
                                        }
                                        Audit.message(10, msg, acc3.ref);
                                        break;
                                    }
                                    cc2 = cc2.next;
                                }
                            } else {
                                if (msg == null) {
                                    msg = Audit.message(8, (AstObject)fld.field, "AuditSync.5", new Object[]{fld.field});
                                }
                                Audit.message(10, msg, acc3.ref);
                            }
                        }
                        acc3 = acc3.next;
                    }
                }
            }
            fld = fld.next;
        }
    }
}

