/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.sync;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.internal.plugin.audit.sync.ClassDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;
import com.togethersoft.sca.internal.plugin.audit.sync.MethodDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.VertexList;

public class CalleeDesc {
    public static final int I_SELF = 1;
    public static final int I_SYNCHRONIZED = 2;
    public static final int I_WAIT_DEADLOCK = 4;
    public static final int I_SPECIAL = 8;
    ClassDesc selfClass;
    MethodDesc method;
    int attr;
    CalleeDesc next;
    AstExpression callExpr;
    GraphVertex[] monitors;

    public CalleeDesc(CalleeDesc next, ClassDesc selfClass, MethodDesc method, int attr, AstExpression callExpr, VertexList monitors) {
        this.next = next;
        this.selfClass = selfClass;
        this.method = method;
        this.attr = attr;
        this.callExpr = callExpr;
        this.monitors = monitors.toArray();
    }

    public CalleeDesc(CalleeDesc next, ClassDesc selfClass, MethodDesc method, CalleeDesc inv) {
        this.next = next;
        this.selfClass = selfClass;
        this.method = method;
        this.attr = inv.attr;
        this.callExpr = inv.callExpr;
        this.monitors = inv.monitors;
    }

    public CalleeDesc(MethodDesc method) {
        this.method = method;
    }

    boolean isSelf() {
        return (this.attr & 1) != 0;
    }

    boolean isSynchronized() {
        return (this.attr & 2) != 0;
    }

    boolean isWaitDeadlock() {
        return (this.attr & 4) != 0;
    }
}

