/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;

public class Util {
    public static boolean isConstant(IVal[] val) {
        int i = 0;
        while (i < val.length) {
            if (!val[i].isConstant()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNull(IVal val) {
        return val.isConstant() && val instanceof IObjectDomain && !((IObjectDomain)val).mayBeNonNull();
    }

    public static boolean isNull(AstObject ast) {
        return ast.getObjectKind() == 37 && ((AstLiteral)ast).getLiteralKind() == 7;
    }

    public static boolean isZero(IValueDomain val) {
        return val.isConstant() && (val instanceof IIntegralDomain && ((IIntegralDomain)val).getHighValue() == 0L || val instanceof IRealDomain && ((IRealDomain)val).getHighValue() == 0.0);
    }

    public static boolean isOne(IValueDomain val) {
        return val.isConstant() && (val instanceof IIntegralDomain && ((IIntegralDomain)val).getHighValue() == 1L || val instanceof IRealDomain && ((IRealDomain)val).getHighValue() == 1.0);
    }

    public static boolean isTrue(IValueDomain val) {
        return val.isConstant() && val instanceof IBooleanDomain && !((IBooleanDomain)val).mayBeFalse();
    }

    public static boolean isFalse(IValueDomain val) {
        return val.isConstant() && val instanceof IBooleanDomain && !((IBooleanDomain)val).mayBeTrue();
    }

    public static AstVariable isAccessorMethod(AstMethod method) {
        if (method == null) {
            return null;
        }
        AstCompoundStatement body = method.getBody();
        if (body == null) {
            return null;
        }
        AstStatement[] stmts = body.getStatements();
        if (stmts.length != 1) {
            return null;
        }
        if (stmts[0].getObjectKind() != 14) {
            return null;
        }
        AstExpression expr = ((AstReturnStatement)stmts[0]).getReturnExpression();
        if (expr == null || expr.getObjectKind() != 40) {
            return null;
        }
        AstDeclaration decl = ((AstSimpleReference)expr).getReferencedElement();
        if (decl != null && decl.getObjectKind() == 9 && decl.getDeclaringType() == method.getDeclaringType()) {
            return (AstVariable)decl;
        }
        return null;
    }

    public static boolean isPrimitive(AstTypeReference type) {
        int tid = type.getKind();
        return tid == 2 || tid == 3 || tid == 4 || tid == 5 || tid == 6 || tid == 7 || tid == 8 || tid == 9;
    }

    public static boolean isChanging(AstObject node) {
        AstObject parent = node.getParent();
        if (parent.getObjectKind() == 32) {
            return ((AstAssignmentExpression)parent).getLeftOperand() == node;
        }
        if (parent.getObjectKind() == 43) {
            int cop = ((AstUnaryExpression)parent).getExpressionKind();
            return cop == 5 || cop == 4 || cop == 7 || cop == 6;
        }
        return false;
    }

    public static boolean isReadWriteMethod(AstMethod method) {
        if (method.getElementName().equals("readObject")) {
            return method.getSignature().equals("(Ljava/io/ObjectInputStream;)V");
        }
        if (method.getElementName().equals("writeObject")) {
            return method.getSignature().equals("(Ljava/io/ObjectOutputStream;)V");
        }
        if (method.getElementName().equals("readResolve")) {
            return method.getSignature().equals("()Ljava/lang/Object;");
        }
        return false;
    }

    public static boolean isLogicalOp(AstExpression expr) {
        if (expr.getObjectKind() != 33) {
            return false;
        }
        int kind = ((AstBinaryExpression)expr).getExpressionKind();
        return kind == 15 || kind == 16;
    }

    public static boolean isForUpdate(AstObject ast) {
        while (ast != null) {
            if (ast.getObjectKind() == 23) {
                AstObject parent = ast.getParent();
                if (parent instanceof AstForStatement) {
                    return ((AstForStatement)parent).getBody() != ast;
                }
                return false;
            }
            ast = ast.getParent();
        }
        return false;
    }

    public static boolean isForInit(AstVariable var) {
        AstObject loop;
        AstObject parent = var.getParent();
        if (parent.getObjectKind() == 24 && (loop = parent.getParent()) instanceof AstForStatement) {
            return ((AstForStatement)loop).getBody() != parent;
        }
        return false;
    }
}

