/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;

public abstract class UsageFinder
extends AuditRule {
    private AstType[] ejbInterfaces;
    private AstType messageListener;
    private HashSet deprecatedMethods = new HashSet();
    private HashSet deprecatedFields = new HashSet();
    private HashSet deprecatedTypes = new HashSet();
    private HashSet deprecatedPackages = new HashSet();
    private boolean processClass;

    public UsageFinder() {
        super(6);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.ejbInterfaces = new AstType[]{this.getProject().getModel().findType("javax/ejb/EJBObject"), this.getProject().getModel().findType("javax/ejb/EJBLocalObject"), this.getProject().getModel().findType("javax/ejb/EJBLocalHome"), this.getProject().getModel().findType("javax/ejb/EJBHome"), this.getProject().getModel().findType("javax/ejb/SessionBean"), this.getProject().getModel().findType("javax/ejb/EntityBean"), this.getProject().getModel().findType("javax/ejb/MessageDrivenBean")};
        this.messageListener = this.getProject().getModel().findType("javax/jms/MessageListener");
    }

    protected void addDeprecatedMethods(String[] methods) {
        int i = 0;
        while (i < methods.length) {
            this.deprecatedMethods.add(methods[i]);
            ++i;
        }
    }

    protected void addDeprecatedFields(String[] fields) {
        int i = 0;
        while (i < fields.length) {
            this.deprecatedFields.add(fields[i]);
            ++i;
        }
    }

    protected void addDeprecatedTypes(String[] types) {
        int i = 0;
        while (i < types.length) {
            this.deprecatedTypes.add(types[i]);
            ++i;
        }
    }

    protected void addDeprecatedPackages(String[] packages) {
        int i = 0;
        while (i < packages.length) {
            this.deprecatedPackages.add(packages[i]);
            ++i;
        }
    }

    public void checkField(AstField field) {
        if (this.processClass) {
            this.processTypeReference((AstObject)field, field.getType());
        }
    }

    public void checkMethod(AstMethod method) {
        if (this.processClass) {
            this.processTypeReference((AstObject)method, method.getReturnType());
        }
    }

    public void checkFieldReference(AstFieldReference expr) {
        if (this.processClass) {
            this.processReference((AstReference)expr);
        }
    }

    public void checkSimpleReference(AstSimpleReference expr) {
        if (this.processClass) {
            this.processReference((AstReference)expr);
        }
    }

    public void checkType(AstType type) {
        if (type.getParent().getObjectKind() == 1) {
            boolean bl = this.processClass = this.getEJBRole(type) != null;
        }
        if (this.processClass) {
            this.processTypeReference((AstObject)type, (AstTypeReference)type.getSuperClass());
            AstType[] ifaces = type.getSuperInterfaces();
            int i = 0;
            while (i < ifaces.length) {
                this.processTypeReference((AstObject)type, (AstTypeReference)ifaces[i]);
                ++i;
            }
        }
    }

    protected AstType getEJBRole(AstType type) {
        int i = 0;
        while (i < this.ejbInterfaces.length) {
            if (type.isDerivedFrom(this.ejbInterfaces[i])) {
                if (i == this.ejbInterfaces.length - 1) {
                    return type.isDerivedFrom(this.messageListener) ? this.ejbInterfaces[i] : null;
                }
                return this.ejbInterfaces[i];
            }
            ++i;
        }
        return null;
    }

    public void checkVariable(AstVariable var) {
        if (this.processClass) {
            this.processTypeReference((AstObject)var, var.getType());
        }
    }

    private void processTypeReference(AstObject referrer, AstTypeReference type) {
        if (type == null) {
            return;
        }
        AstType base = type.getBaseType();
        if (base == null) {
            return;
        }
        if (this.deprecatedTypes.contains(base.getQualifiedName())) {
            this.message(referrer);
        }
        if (this.deprecatedPackages.contains(base.getPackage().getQualifiedName())) {
            this.message(referrer);
        }
    }

    private void processReference(AstReference expr) {
        AstDeclaration decl = expr.getReferencedElement();
        if (decl == null) {
            return;
        }
        if (decl.getObjectKind() == 8) {
            this.processTypeReference((AstObject)expr, (AstTypeReference)((AstType)decl));
        } else if (decl.getObjectKind() == 6) {
            if (this.deprecatedMethods.contains(((AstMethod)decl).getQualifiedName() + ((AstMethod)decl).getSignature())) {
                this.message((AstObject)expr);
            }
            this.processTypeReference((AstObject)expr, (AstTypeReference)decl.getDeclaringType());
        } else if (decl.getObjectKind() == 9 && decl.getParent() instanceof AstType && this.deprecatedFields.contains(((AstField)decl).getQualifiedName())) {
            this.message((AstObject)expr);
        }
    }
}

