/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class URSP
extends AuditRule {
    public URSP() {
        super(1);
    }

    public void checkReturnStatement(AstReturnStatement stmt) {
        IAuditMessage m;
        final AstExpression expr = stmt.getReturnExpression();
        if (expr != null && expr.getObjectKind() == 46 && (m = this.message((AstObject)expr)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditURSP.Autofix"){

                public boolean fix() {
                    expr.replaceWith((AstObject)((AstParenthesizedExpression)expr).getExpression());
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.remove(expr.getPosition().getStartLine(), expr.getPosition().getStartColumn(), expr.getPosition().getStartLine(), expr.getPosition().getStartColumn() + 1);
            fix.remove(expr.getPosition().getEndLine(), expr.getPosition().getEndColumn() - 1, expr.getPosition().getEndLine(), expr.getPosition().getEndColumn());
        }
    }
}

