/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ULVFP
extends AuditRule {
    public ULVFP() {
        super(4);
    }

    public void checkVariable(final AstVariable decl) {
        IAuditMessage m;
        if (decl.getParent().getObjectKind() != 6 && decl.getReferences().length == 0 && (m = this.message((AstObject)decl, "AuditULVFP.1", new Object[]{decl})) != null) {
            final AstDeclarationStatement declStmt = (AstDeclarationStatement)decl.getParent();
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditULVFP.Autofix"){

                public boolean fix() {
                    if (declStmt.getDeclarations().length == 1) {
                        declStmt.remove();
                    } else {
                        decl.remove();
                    }
                    return true;
                }
            });
            if (declStmt.getDeclarations().length == 1) {
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                fix.removeBlock(declStmt.getPosition());
            }
        }
    }

    public void checkMethod(AstMethod method) {
        if (this.isMethodOverridable(method)) {
            return;
        }
        if (Util.isReadWriteMethod(method)) {
            return;
        }
        AstMethod[] overriders = Audit.getMethodHierarchy(method);
        AstVariable[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            block6: {
                if (params[i].getReferences().length <= 0) {
                    int j = 0;
                    while (j < overriders.length) {
                        if (overriders[j].getParameters()[i].getReferences().length <= 0) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    this.message((AstObject)params[i], "AuditULVFP.2", new Object[]{params[i]});
                }
            }
            ++i;
        }
    }
}

