/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class UL
extends AuditRule {
    public UL() {
        super(2);
    }

    public void checkLiteral(final AstLiteral expr) {
        IAuditMessage m;
        String textValue;
        if (expr.getLiteralKind() == 1 && (textValue = expr.getText()).endsWith("l") && (m = this.message((AstObject)expr)) != null) {
            final String newValue = textValue.substring(0, textValue.length() - 1) + 'L';
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditUL.Autofix"){

                public boolean fix() {
                    expr.setText(newValue);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.remove(expr.getPosition());
            fix.insert(newValue);
        }
    }
}

