/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModifier;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class UIMM
extends AuditRule {
    public UIMM() {
        super(4);
    }

    public void checkMethod(final AstMethod method) {
        IAuditMessage m;
        if (!method.getDeclaringType().isInterface()) {
            return;
        }
        if (((method.getDeclaredModifiers() & 1) != 0 || (method.getDeclaredModifiers() & 0x400) != 0) && (m = this.message((AstObject)method)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditUIMM.Autofix"){

                public boolean fix() {
                    method.setDeclaredModifiers(method.getDeclaredModifiers() & 0xFFFFFBFE);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            AstModifier[] modifiers = method.getModifiersList();
            int i = 0;
            while (i < modifiers.length) {
                if ((modifiers[i].getModifier() & 0x401) != 0) {
                    fix.removeWithSpace(modifiers[i].getPosition());
                }
                ++i;
            }
        }
    }

    public void checkField(final AstField field) {
        IAuditMessage m;
        if (!field.getDeclaringType().isInterface()) {
            return;
        }
        if (((field.getDeclaredModifiers() & 1) != 0 || (field.getDeclaredModifiers() & 8) != 0 || (field.getDeclaredModifiers() & 0x10) != 0) && (m = this.message((AstObject)field)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditUIMM.Autofix"){

                public boolean fix() {
                    field.setDeclaredModifiers(field.getDeclaredModifiers() & 0xFFFFFFE6);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            AstModifier[] modifiers = field.getModifiersList();
            int i = 0;
            while (i < modifiers.length) {
                if ((modifiers[i].getModifier() & 0x19) != 0) {
                    fix.removeWithSpace(modifiers[i].getPosition());
                }
                ++i;
            }
        }
    }
}

