/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class UE
extends AuditRule {
    public UE() {
        super(2);
    }

    public void checkBinaryExpression(final AstBinaryExpression expr) {
        if (!(expr.getExpressionKind() != 20 && expr.getExpressionKind() != 19 || Util.isNull((AstObject)expr.getLeftOperand()) || Util.isNull((AstObject)expr.getRightOperand()))) {
            IAuditMessage m;
            AstTypeReference leftType = expr.getLeftOperand().getType();
            AstTypeReference rightType = expr.getRightOperand().getType();
            if ((leftType != null && "java/lang/String".equals(leftType.getTypeName()) || rightType != null && "java/lang/String".equals(rightType.getTypeName())) && (m = this.message((AstObject)expr)) != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditUE.Autofix"){

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        AstExpression[] args = new AstExpression[]{expr.getRightOperand()};
                        AstMethodCallExpression equals = factory.createAstMethodCallExpression((AstExpression)factory.createAstFieldReference(expr.getLeftOperand(), 1, "equals"), args);
                        expr.replaceWith((AstObject)equals);
                        return true;
                    }
                });
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                fix.remove(expr.getLeftOperand().getPosition().getEndLine(), expr.getLeftOperand().getPosition().getEndColumn(), expr.getRightOperand().getPosition().getStartLine(), expr.getRightOperand().getPosition().getStartColumn());
                fix.insert(".equals(");
                fix.insertAfter(expr.getRightOperand().getPosition(), ")");
            }
        }
    }
}

