/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterList;
import com.togethersoft.sca.core.IParameterString;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class UCVN
extends AuditRule {
    private HashMap allowed = new HashMap();

    public UCVN() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterList list = (IParameterList)analyzer.getParameterRegistry().getParameter("name-list", 5);
        if (list != null) {
            IParameter[] params = list.getParameterList();
            int i = 0;
            while (i < params.length) {
                if (params[i].getType() == 2 && !params[i].getId().equals("severity")) {
                    String id = params[i].getId().replace('.', '/');
                    HashSet<String> s = (HashSet<String>)this.allowed.get(id);
                    if (s == null) {
                        s = new HashSet<String>();
                        this.allowed.put(id, s);
                    }
                    StringTokenizer st = new StringTokenizer(((IParameterString)params[i]).getValue(), ", ");
                    while (st.hasMoreTokens()) {
                        s.add(st.nextToken());
                    }
                }
                ++i;
            }
        }
    }

    public void checkVariable(AstVariable var) {
        HashSet s;
        if (!(var.getElementName().length() != 1 || (s = (HashSet)this.allowed.get(var.getType().getTypeName())) != null && s.contains(var.getElementName()))) {
            Object[] values = null;
            if (s != null) {
                values = new Object[s.size()];
                Iterator i = s.iterator();
                int j = 0;
                while (i.hasNext()) {
                    values[j++] = i.next();
                }
            }
            this.message((AstObject)var, new Object[]{var.getElementName(), var.getType().getTypeName(), values});
        }
    }

    public String getExplainMessage(AstObject ast, String messageId, Object[] values) {
        String tmplFileName = values[2] == null ? "UCVN_1" : "UCVN_2";
        return super.getExplainMessage(tmplFileName, ast, messageId, values);
    }
}

