/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class UC
extends AuditRule {
    public UC() {
        super(2);
    }

    public void checkCastExpression(final AstCastExpression expr) {
        IAuditMessage m;
        AstTypeReference castType = expr.getCastType();
        AstTypeReference exprType = expr.getExpression().getType();
        if (castType.getKind() != 0 && exprType.getKind() != 0 && (exprType == castType || exprType.isDerivedFrom(castType) || this.isWideningConversion(exprType, castType, this.isIntegerOperation((AstExpression)expr, expr.getParent()))) && (m = this.message((AstObject)expr)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditUTC.Autofix"){

                public boolean fix() {
                    expr.replaceWith((AstObject)expr.getExpression());
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.remove(expr.getPosition().getStartLine(), expr.getPosition().getStartColumn(), expr.getExpression().getPosition().getStartLine(), expr.getExpression().getPosition().getStartColumn());
        }
    }

    private boolean isIntegerOperation(AstExpression op, AstObject ast) {
        AstBinaryExpression expr;
        if (ast.getObjectKind() == 33 && ((expr = (AstBinaryExpression)ast).getExpressionKind() == 4 || expr.getExpressionKind() == 5 || expr.getExpressionKind() == 1 || expr.getExpressionKind() == 2)) {
            AstExpression op2 = expr.getLeftOperand() != op ? expr.getLeftOperand() : expr.getRightOperand();
            int tid = op2.getType().getKind();
            return tid == 2 || tid == 4 || tid == 3 || tid == 5 || tid == 6;
        }
        return false;
    }

    private boolean isWideningConversion(AstTypeReference from, AstTypeReference to, boolean isIntegerOperation) {
        int tid1 = from.getKind();
        int tid2 = to.getKind();
        switch (tid1) {
            case 2: {
                return tid2 == 3 || tid2 == 5 || tid2 == 6 || !isIntegerOperation && (tid2 == 7 || tid2 == 8);
            }
            case 3: {
                return tid2 == 5 || tid2 == 6 || !isIntegerOperation && (tid2 == 7 || tid2 == 8);
            }
            case 4: {
                return tid2 == 5 || tid2 == 6 || !isIntegerOperation && (tid2 == 7 || tid2 == 8);
            }
            case 5: {
                return tid2 == 6 || !isIntegerOperation && (tid2 == 7 || tid2 == 8);
            }
            case 6: {
                return !isIntegerOperation && (tid2 == 7 || tid2 == 8);
            }
            case 7: {
                return !isIntegerOperation && tid2 == 8;
            }
        }
        return false;
    }
}

