/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class UAAO
extends AuditRule {
    public UAAO() {
        super(2);
    }

    public void checkAssignmentExpression(final AstAssignmentExpression expr) {
        AstExpression operand;
        int letOp;
        if (expr.getExpressionKind() != 0) {
            return;
        }
        AstDeclaration decl = this.getDecl(expr.getLeftOperand());
        if (decl == null) {
            return;
        }
        if (expr.getRightOperand().getObjectKind() != 33) {
            return;
        }
        AstBinaryExpression re = (AstBinaryExpression)expr.getRightOperand();
        if (this.getDecl(re.getLeftOperand()) == decl) {
            switch (re.getExpressionKind()) {
                case 1: {
                    letOp = 3;
                    break;
                }
                case 2: {
                    letOp = 4;
                    break;
                }
                case 3: {
                    letOp = 5;
                    break;
                }
                case 4: {
                    letOp = 1;
                    break;
                }
                case 5: {
                    letOp = 2;
                    break;
                }
                case 6: {
                    letOp = 8;
                    break;
                }
                case 7: {
                    letOp = 6;
                    break;
                }
                case 8: {
                    letOp = 7;
                    break;
                }
                case 12: {
                    letOp = 9;
                    break;
                }
                case 14: {
                    letOp = 11;
                    break;
                }
                case 13: {
                    letOp = 10;
                    break;
                }
                default: {
                    return;
                }
            }
            operand = re.getRightOperand();
        } else if (this.getDecl(re.getRightOperand()) == decl) {
            switch (re.getExpressionKind()) {
                case 4: {
                    if (expr.getType().getTypeName().equals("java/lang/String")) {
                        return;
                    }
                    letOp = 1;
                    break;
                }
                case 1: {
                    letOp = 3;
                    break;
                }
                case 12: {
                    letOp = 9;
                    break;
                }
                case 14: {
                    letOp = 11;
                    break;
                }
                case 13: {
                    letOp = 10;
                    break;
                }
                default: {
                    return;
                }
            }
            operand = re.getLeftOperand();
        } else {
            return;
        }
        IAuditMessage m = this.message((AstObject)expr);
        if (m != null) {
            final AstExpression src = operand;
            final int kind = letOp;
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditUAAO.Autofix"){

                public boolean fix() {
                    AstObjectFactory factory = Factory.getObjectFactory();
                    expr.replaceWith((AstObject)factory.createAstAssignmentExpression(kind, expr.getLeftOperand(), src));
                    return true;
                }
            });
        }
    }

    private AstDeclaration getDecl(AstExpression expr) {
        if (expr.getObjectKind() == 40) {
            return ((AstSimpleReference)expr).getReferencedElement();
        }
        return null;
    }
}

