/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class SL
extends AuditRule {
    private boolean ignoreSpaces;
    private boolean ignoreDigits;

    public SL() {
        super(2);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterBoolean param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Ignore white spaces", 1);
        if (param != null) {
            this.ignoreSpaces = param.getValue();
        }
        if ((param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Ignore digits", 1)) != null) {
            this.ignoreDigits = param.getValue();
        }
    }

    public void checkLiteral(AstLiteral literal) {
        if (literal.getLiteralKind() == 6) {
            String str = literal.getText();
            int i = 1;
            while (i < str.length() - 1) {
                if (!(this.ignoreSpaces && Character.isWhitespace(str.charAt(i)) || this.ignoreDigits && Character.isDigit(str.charAt(i)))) {
                    this.message((AstObject)literal);
                    return;
                }
                ++i;
            }
        }
    }
}

