/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstEmptyStatement;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class SEB
extends AuditRule {
    public SEB() {
        super(1);
    }

    public void checkEmptyStatement(AstEmptyStatement stmt) {
        this.message((AstObject)stmt);
    }

    public void checkDoStatement(AstDoStatement stmt) {
        this.processStmt(stmt.getBody());
    }

    public void checkForStatement(AstForStatement stmt) {
        this.processStmt(stmt.getBody());
    }

    public void checkIfStatement(AstIfStatement stmt) {
        this.processStmt(stmt.getThenStatement());
        this.processStmt(stmt.getElseStatement());
    }

    public void checkSwitchStatement(AstSwitchStatement stmt) {
        if (stmt.getBody().length == 0) {
            this.message((AstObject)stmt);
        }
    }

    public void checkTryStatement(AstTryStatement stmt) {
        this.processStmt((AstStatement)stmt.getBody());
        if (stmt.getFinallyClause() != null) {
            this.processStmt((AstStatement)stmt.getFinallyClause().getBody());
        }
    }

    public void checkWhileStatement(AstWhileStatement stmt) {
        this.processStmt(stmt.getBody());
    }

    private void processStmt(AstStatement stmt) {
        if (stmt instanceof AstCompoundStatement && ((AstCompoundStatement)stmt).getStatements().length == 0) {
            this.message((AstObject)stmt);
        }
    }
}

