/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class SDMC
extends AuditRule {
    public SDMC() {
        super(4);
    }

    public void checkType(AstType type) {
        AstType[] subtypes = type.getSubtypes();
        if (subtypes.length < 2) {
            return;
        }
        int i = 0;
        while (i < subtypes.length) {
            AstType subtype = subtypes[i];
            AstField[] fields = subtype.getFields();
            int j = 0;
            while (j < fields.length) {
                if (!fields[j].isFinal() || !fields[j].isStatic()) {
                    return;
                }
                ++j;
            }
            AstMethod[] methods = subtype.getMethods();
            if (methods.length < 1) {
                return;
            }
            int j2 = 0;
            while (j2 < methods.length) {
                if (!this.isConstantMethod(methods[j2])) {
                    return;
                }
                ++j2;
            }
            ++i;
        }
        IAuditMessage msg = this.message((AstObject)type, "AuditSDMC.1", new Object[]{type});
        int i2 = 0;
        while (i2 < subtypes.length) {
            this.message(msg, (AstObject)subtypes[i2], "AuditSDMC.2", new Object[]{subtypes[i2]});
            ++i2;
        }
    }

    private boolean isConstantMethod(AstMethod method) {
        AstCompoundStatement body = method.getBody();
        if (body == null) {
            return false;
        }
        AstStatement[] stmts = body.getStatements();
        if (stmts.length != 1) {
            return false;
        }
        if (stmts[0].getObjectKind() != 14) {
            return false;
        }
        AstReturnStatement ret = (AstReturnStatement)stmts[0];
        AstExpression val = ret.getReturnExpression();
        return val != null && val.isConstant();
    }
}

