/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SwitchTuple;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class SBCCS
extends AuditRule {
    public SBCCS() {
        super(8);
    }

    public void checkBasicBlock(IBasicBlock block) {
        if (this.isEmptyBlock(block)) {
            return;
        }
        ITuple first = block.getFirstTuple();
        AstObject firstStmt = first.getAstObject();
        while (firstStmt != null && !(firstStmt instanceof AstSwitchGroup)) {
            firstStmt = firstStmt.getParent();
        }
        if (firstStmt == null) {
            return;
        }
        final AstSwitchGroup nextSwitchGroup = (AstSwitchGroup)firstStmt;
        if (SBCCS.hasFallThroughComment(nextSwitchGroup)) {
            return;
        }
        IBasicBlock[] predecessor = block.getPredecessors();
        boolean fallThrough = false;
        AstObject switchStmt = null;
        if (predecessor != null) {
            IAuditMessage m;
            int i = 0;
            while (i < predecessor.length) {
                ITuple last = predecessor[i].getLastTuple();
                ITuple next = last.getNext();
                if (last.getCode() == 42 && (last.target(0) != first || ((SwitchTuple)last).hasDefault())) {
                    switchStmt = last.getAstObject();
                } else if (next == first && last.getCode() != 44) {
                    fallThrough = true;
                }
                ++i;
            }
            if (switchStmt != null && fallThrough && this.isInSwitch(switchStmt, block) && (m = this.message(first.getAstObject())) != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditSBCCS.Autofix.1"){

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        AstComment comment = factory.createAstComment("// nobreak");
                        AstObject parent = nextSwitchGroup.getParent();
                        if (parent instanceof AstSwitchStatement) {
                            AstStatement[] stmts;
                            AstSwitchGroup[] groups = ((AstSwitchStatement)parent).getBody();
                            int i = groups.length;
                            while (--i > 0 && groups[i] != nextSwitchGroup) {
                            }
                            if (i > 0 && (stmts = groups[i - 1].getStatements()).length > 0) {
                                comment.setPositionAfter(stmts[stmts.length - 1].getPosition());
                            }
                        }
                        nextSwitchGroup.addComment(comment);
                        return true;
                    }
                });
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditSBCCS.Autofix.2"){

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        AstBreakStatement breakStmt = factory.createAstBreakStatement();
                        AstObject parent = nextSwitchGroup.getParent();
                        if (parent instanceof AstSwitchStatement) {
                            AstSwitchGroup[] groups = ((AstSwitchStatement)parent).getBody();
                            int i = groups.length;
                            while (--i > 0 && groups[i] != nextSwitchGroup) {
                            }
                            if (i > 0) {
                                groups[i - 1].addStatement((AstStatement)breakStmt);
                            }
                        }
                        return true;
                    }
                });
                ESAutoFix fix1 = new ESAutoFix(m, AuditRule.getAutoFixName(m, 1));
                fix1.indent(nextSwitchGroup.getPosition().getStartLine(), nextSwitchGroup.getStatements()[0].getPosition().getStartColumn());
                fix1.insertLine("// no break");
                fix1.setTabSize(this.getProject().getTabSize());
                ESAutoFix fix2 = new ESAutoFix(m, AuditRule.getAutoFixName(m, 2));
                fix2.indent(nextSwitchGroup.getPosition().getStartLine(), nextSwitchGroup.getStatements()[0].getPosition().getStartColumn());
                fix2.insertLine("break;");
                fix2.setTabSize(this.getProject().getTabSize());
            }
        }
    }

    private boolean isInSwitch(AstObject switchStmt, IBasicBlock block) {
        if (block.getFirstTuple().getCode() == 40) {
            ITuple next = block.getFirstTuple().getNext();
            if (next == null) {
                return false;
            }
            AstObject parent = next.getAstObject();
            while (parent != null) {
                if (parent == switchStmt) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    private boolean isEmptyBlock(IBasicBlock block) {
        ITuple last = block.getLastTuple();
        ITuple tuple = block.getFirstTuple();
        while (tuple != null) {
            int code = tuple.getCode();
            if (code != 40 && code != 44) {
                return false;
            }
            if (tuple == last) break;
            tuple = tuple.getNext();
        }
        return true;
    }

    private static boolean hasFallThroughComment(AstSwitchGroup obj) {
        AstComment[] comments = obj.getComments();
        if (comments.length > 0) {
            int i = comments.length;
            if (--i >= 0) {
                String comment = comments[i].getComment().substring(2).trim();
                return comment.equalsIgnoreCase("no break") || comment.equalsIgnoreCase("nobreak") || comment.equalsIgnoreCase("fall through") || comment.equalsIgnoreCase("falls through");
            }
        }
        return false;
    }
}

