/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class RVNU
extends AuditRule {
    private boolean used;

    public RVNU() {
        super(8);
    }

    public void checkMethod(IMethod mth, AstMethod method) {
        if (this.isMethodOverridable(method)) {
            return;
        }
        if (!mth.isReachable() || method.getReturnType().getKind() == 1) {
            return;
        }
        this.used = false;
        AstMethod[] hierarchy = Audit.getMethodHierarchy(method);
        int i = 0;
        while (i < hierarchy.length) {
            if (this.isRetValUsed(hierarchy[i])) {
                return;
            }
            ++i;
        }
        if (this.used) {
            this.message((AstObject)method);
        }
    }

    private boolean isRetValUsed(AstMethod method) {
        AstReference[] refs = method.getReferences();
        int i = 0;
        while (i < refs.length) {
            this.used = true;
            if (refs[i] instanceof AstMethodCallExpression && refs[i].getParent().getObjectKind() != 23) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

