/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstImport;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;

public class RIP
extends AuditRule {
    private HashSet deprecatedPackages = new HashSet();
    private HashSet allowedPackages = new HashSet();
    private boolean processFile;

    public RIP() {
        super(6);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameter[] params = analyzer.getParameterRegistry().getParameters();
        int i = 0;
        while (i < params.length) {
            AstPackage pkg;
            if (!params[i].getId().equals("severity") && !params[i].getId().equals("enabled") && (pkg = this.getProject().getModel().findPackage(params[i].getId().replace('.', '/'))) != null) {
                this.deprecatedPackages.add(pkg);
            }
            ++i;
        }
    }

    public void checkCompilationUnit(AstCompilationUnit file) {
        boolean bl = this.processFile = !this.deprecatedPackages.contains(file.getPackage());
        if (!this.processFile) {
            return;
        }
        AstImport[] imports = file.getImports();
        int i = 0;
        while (i < imports.length) {
            AstDeclaration decl = imports[i].getReferencedElement();
            if (decl != null) {
                if (decl.getObjectKind() == 7) {
                    if (this.deprecatedPackages.contains(decl)) {
                        this.message((AstObject)imports[i]);
                    }
                } else if (decl.getObjectKind() == 8) {
                    this.processTypeReference((AstObject)imports[i], (AstTypeReference)((AstType)decl));
                }
            }
            ++i;
        }
    }

    public void checkField(AstField field) {
        if (this.processFile) {
            this.processTypeReference((AstObject)field, field.getType());
        }
    }

    public void checkFieldReference(AstFieldReference expr) {
        AstDeclaration decl;
        if (this.processFile && (decl = expr.getReferencedElement()) != null && (decl.getObjectKind() == 9 || decl.getObjectKind() == 6)) {
            this.processTypeReference((AstObject)expr, (AstTypeReference)decl.getDeclaringType());
        }
    }

    public void checkMethod(AstMethod method) {
        if (this.processFile) {
            this.processTypeReference((AstObject)method, method.getReturnType());
        }
    }

    public void checkObjectCreationExpression(AstObjectCreationExpression expr) {
        if (this.processFile) {
            this.processTypeReference((AstObject)expr, (AstTypeReference)expr.getObjectType());
        }
    }

    public void checkType(AstType type) {
        if (this.processFile) {
            this.processTypeReference((AstObject)type, (AstTypeReference)type.getSuperClass());
            AstType[] superIfaces = type.getSuperInterfaces();
            int i = 0;
            while (i < superIfaces.length) {
                this.processTypeReference((AstObject)type, (AstTypeReference)superIfaces[i]);
                ++i;
            }
        }
    }

    public void checkVariable(AstVariable var) {
        if (this.processFile) {
            this.processTypeReference((AstObject)var, var.getType());
        }
    }

    private void processTypeReference(AstObject referrer, AstTypeReference type) {
        if (type == null) {
            return;
        }
        AstType base = type.getBaseType();
        if (base == null) {
            return;
        }
        if (this.deprecatedPackages.contains(base.getPackage())) {
            this.message(referrer);
        }
    }
}

