/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PPCF
extends AuditRule {
    public PPCF() {
        super(4);
    }

    public void checkCompilationUnit(AstCompilationUnit file) {
        boolean foundNonPublic = false;
        final AstType[] types = file.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].isPublic()) {
                IAuditMessage m;
                if (foundNonPublic && (m = this.message((AstObject)types[i], "AuditPPCF.1", new Object[]{types[i]})) != null) {
                    m.addAutoFix((AutoFix)new ASTAutoFix("AuditPPCF.Autofix"){

                        public boolean fix() {
                            boolean swapped;
                            do {
                                swapped = false;
                                int i = 1;
                                while (i < types.length) {
                                    if (!types[i - 1].isPublic() && types[i].isPublic()) {
                                        types[i - 1].swapWith((AstDeclaration)types[i]);
                                        AstType tmp = types[i - 1];
                                        types[i - 1] = types[i];
                                        types[i] = tmp;
                                        swapped = true;
                                    }
                                    ++i;
                                }
                            } while (swapped);
                            return true;
                        }
                    });
                }
            } else {
                foundNonPublic = true;
            }
            ++i;
        }
    }
}

