/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PPA
extends AuditRule {
    private boolean formally;
    private boolean allowPackage;

    public PPA() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterBoolean param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Formally", 1);
        if (param != null) {
            this.formally = param.getValue();
        }
        if ((param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Allow package attributes", 1)) != null) {
            this.allowPackage = param.getValue();
        }
    }

    public void checkField(AstField field) {
        if (field.isFinal() || field.isProtected() || field.isPrivate()) {
            return;
        }
        if (this.allowPackage && !field.isPublic()) {
            return;
        }
        if (!this.formally && field.getDeclaringType().getExecutableFragments().length == 0) {
            return;
        }
        this.message((AstObject)field);
    }
}

