/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PMFL
extends AuditRule {
    public PMFL() {
        super(4);
    }

    public void checkType(final AstType type) {
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals("main")) {
                IAuditMessage m;
                if (methods[i].getSignature().equals("([Ljava/lang/String;)V")) {
                    if (i != methods.length - 1) {
                        final AstMethod main = methods[i];
                        m = this.message((AstObject)methods[i], "AuditPMFL.1", new Object[]{methods[i]});
                        if (m != null) {
                            m.addAutoFix((AutoFix)new ASTAutoFix("AuditPMFL.Autofix"){

                                public boolean fix() {
                                    AstDeclaration[] members = type.getMembers();
                                    int j = 0;
                                    while (members[j] != main) {
                                        ++j;
                                    }
                                    while (++j < members.length) {
                                        main.swapWith(members[j]);
                                    }
                                    return true;
                                }
                            });
                        }
                    }
                } else {
                    m = this.message((AstObject)methods[i], "AuditPMFL.2", new Object[]{methods[i]});
                }
            }
            ++i;
        }
    }
}

