/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstJavadocTag;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PJDC
extends AuditRule {
    private int checkClass;
    private int checkAuthor;
    private int checkVersion;
    private int checkAttribute;
    private int checkOperation;
    private boolean checkParam;
    private boolean orderedParam;
    private boolean checkThrows;
    private boolean orderedThrows;
    private boolean checkReturn;

    public PJDC() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.checkClass = this.readMode(analyzer, "Class");
        this.checkAuthor = this.readMode(analyzer, "@author");
        this.checkVersion = this.readMode(analyzer, "@version");
        this.checkAttribute = this.readMode(analyzer, "Attribute");
        this.checkOperation = this.readMode(analyzer, "Operation");
        this.checkParam = analyzer.getParameterRegistry().getBooleanValue("@param", true);
        this.orderedParam = analyzer.getParameterRegistry().getBooleanValue("Ordered @param", true);
        this.checkThrows = analyzer.getParameterRegistry().getBooleanValue("@throws", true);
        this.orderedThrows = analyzer.getParameterRegistry().getBooleanValue("Ordered @throws", true);
        this.checkReturn = analyzer.getParameterRegistry().getBooleanValue("@return", true);
    }

    public void checkType(AstType decl) {
        if (!this.check((AstDeclaration)decl, this.checkClass)) {
            return;
        }
        AstComment[] comments = decl.getComments();
        if (comments.length == 0 || !comments[comments.length - 1].isJavadoc()) {
            this.message((AstObject)decl, "AuditPJDC.1", null);
        } else {
            AstJavadocTag[] tags = comments[comments.length - 1].getJavadocTags();
            this.checkTag((AstDeclaration)decl, tags, "@author", this.checkAuthor);
            this.checkTag((AstDeclaration)decl, tags, "@version", this.checkVersion);
        }
        AstField[] fields = decl.getFields();
        int i = 0;
        while (i < fields.length) {
            if (this.check((AstDeclaration)fields[i], this.checkAttribute) && ((comments = fields[i].getComments()).length == 0 || !comments[comments.length - 1].isJavadoc())) {
                this.message((AstObject)fields[i], "AuditPJDC.1", null);
            }
            ++i;
        }
        AstMethod[] methods = decl.getExecutableFragments();
        int i2 = 0;
        while (i2 < methods.length) {
            if (!methods[i2].isInitializer() && this.check((AstDeclaration)methods[i2], this.checkAttribute)) {
                comments = methods[i2].getComments();
                if (comments.length == 0 || !comments[comments.length - 1].isJavadoc()) {
                    this.message((AstObject)methods[i2], "AuditPJDC.1", null);
                } else {
                    AstJavadocTag[] tags = comments[comments.length - 1].getJavadocTags();
                    this.checkMethodTags(methods[i2], tags);
                }
            }
            ++i2;
        }
    }

    private void checkMethodTags(AstMethod method, AstJavadocTag[] tags) {
        int i;
        boolean checkOrder;
        int prevPosition;
        if (this.checkReturn && method.getReturnType().getKind() != 1) {
            this.checkTag((AstDeclaration)method, tags, "@return", 0);
        }
        if (this.checkParam) {
            prevPosition = -1;
            checkOrder = this.orderedParam;
            AstVariable[] params = method.getParameters();
            i = 0;
            while (i < params.length) {
                int j;
                block16: {
                    j = 0;
                    while (j < tags.length) {
                        if (tags[j].getTag().equals("@param") && tags[j].getArgument() != null && tags[j].getArgument().startsWith(params[i].getElementName())) {
                            if (checkOrder && prevPosition > j) {
                                checkOrder = false;
                                this.message((AstObject)method, "AuditPJDC.2", null);
                            }
                            break block16;
                        }
                        ++j;
                    }
                    this.message((AstObject)method, "AuditPJDC.3", new Object[]{params[i]});
                    break;
                }
                prevPosition = j;
                ++i;
            }
        }
        if (this.checkThrows) {
            prevPosition = -1;
            checkOrder = this.orderedThrows;
            AstTypeReference[] exceptions = method.getExceptionTypes();
            i = 0;
            while (i < tags.length) {
                if (tags[i].getTag().equals("@throws") && tags[i].getArgument() != null) {
                    if (checkOrder && prevPosition >= 0 && tags[prevPosition].getArgument().compareTo(tags[i].getArgument()) > 0) {
                        checkOrder = false;
                        this.message((AstObject)method, "AuditPJDC.4", null);
                    }
                    prevPosition = i;
                    String typeName = tags[i].getArgument().replace('.', '/');
                    int j = 0;
                    while (j < exceptions.length) {
                        if (exceptions[j] != null) {
                            if (exceptions[j].getTypeName().equals(typeName)) {
                                exceptions[j] = null;
                                break;
                            }
                            AstType type = exceptions[j].getBaseType();
                            if (type != null && (type.getPackage() == method.getPackage() || type.getPackage().getQualifiedName().equals("java/lang")) && type.getTypeQualifiedName().equals(typeName)) {
                                exceptions[j] = null;
                                break;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int j = 0;
            while (j < exceptions.length) {
                if (exceptions[j] != null) {
                    this.message((AstObject)method, "AuditPJDC.5", new Object[]{exceptions[j].getTypeName()});
                }
                ++j;
            }
        }
    }

    private void checkTag(AstDeclaration decl, AstJavadocTag[] tags, String key, int mode) {
        if (!this.check(decl, mode)) {
            return;
        }
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getTag().equals(key)) {
                return;
            }
            ++i;
        }
        this.message((AstObject)decl, "AuditPJDC.6", new Object[]{key});
    }

    private int readMode(IAnalyzerDescriptor analyzer, String id) {
        IParameterStringEnum iParameterStringEnum = (IParameterStringEnum)analyzer.getParameterRegistry().getParameter(id, 4);
        if (iParameterStringEnum != null) {
            return iParameterStringEnum.getOrdinalValue();
        }
        return 0;
    }

    private boolean check(AstDeclaration decl, int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
            case 1: {
                return !decl.isPrivate();
            }
            case 2: {
                return decl.isPublic() | decl.isProtected();
            }
            case 3: {
                return decl.isPublic();
            }
        }
        return false;
    }
}

