/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PIOBCL
extends AuditRule {
    public PIOBCL() {
        super(8);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (tuple.getCode() == 28 && values[0].getValueType() == 4 && result.getValueType() == 5) {
            IAuditMessage m;
            AstBinaryExpression binexp;
            int op;
            AstObject obj = tuple.getAstObject();
            AstExpression expr = null;
            if (obj instanceof AstCastExpression) {
                expr = ((AstCastExpression)obj).getExpression();
            } else if (obj instanceof AstExpression) {
                expr = (AstExpression)obj;
            }
            if (expr instanceof AstBinaryExpression && ((op = (binexp = (AstBinaryExpression)expr).getExpressionKind()) == 1 || op == 6) && (m = this.message(tuple.getAstObject())) != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditPIOBCL.Autofix"){

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        AstCastExpression cast = factory.createAstCastExpression(factory.createAstTypeExpression("long"), binexp.getLeftOperand());
                        binexp.getLeftOperand().replaceWith((AstObject)cast, (AstObject)binexp);
                        return true;
                    }
                });
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                fix.insert(binexp.getLeftOperand().getPosition(), "(long)");
            }
        }
    }
}

