/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PFC
extends AuditRule {
    private boolean checkClassName;

    public PFC() {
        super(4);
    }

    public void checkCompilationUnit(AstCompilationUnit file) {
        int idx;
        AstType[] types;
        String filecomment = null;
        AstComment[] comments = file.getComments();
        if (comments.length > 0 && !comments[0].isJavadoc() && !comments[0].isSingleLine()) {
            filecomment = comments[0].getComment();
        }
        if (filecomment == null) {
            this.message((AstObject)file);
        } else if (this.checkClassName && (types = file.getTypes()).length > 0 && (idx = filecomment.indexOf(types[0].getElementName())) < 0) {
            this.message((AstObject)comments[0], "AuditPFC.1", null);
        }
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.checkClassName = analyzer.getParameterRegistry().getBooleanValue("Check class name", true);
    }
}

