/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstConditionalExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class PCO
extends AuditRule {
    public PCO() {
        super(2);
    }

    public void checkConditionalExpression(final AstConditionalExpression expr) {
        IAuditMessage m;
        final AstExpression condExpr = expr.testExpression();
        if (condExpr.getObjectKind() == 33 && (m = this.message((AstObject)expr)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditPCO.Autofix"){

                public boolean fix() {
                    AstObjectFactory factory = Factory.getObjectFactory();
                    condExpr.replaceWith((AstObject)factory.createAstParenthesizedExpression(condExpr), (AstObject)expr);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.insert(condExpr.getPosition(), "(");
            fix.insertAfter(condExpr.getPosition(), ")");
        }
    }
}

