/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class OWS
extends AuditRule {
    public OWS() {
        super(4);
    }

    public void checkType(AstType type) {
        HashSet<String> processed = new HashSet<String>();
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!processed.contains(methods[i].getElementName())) {
                this.processMethod(methods[i]);
                processed.add(methods[i].getElementName());
            }
            ++i;
        }
    }

    private void processMethod(AstMethod method) {
        if (method.isStatic() || method.isFinal() || method.isAbstract()) {
            return;
        }
        AstType superclass = method.getDeclaringType().getSuperClass();
        while (superclass != null) {
            HashSet notOverridden = this.checkAncestorType(method, superclass);
            if (notOverridden.size() > 0) {
                Iterator i = notOverridden.iterator();
                ArrayList<String> array = new ArrayList<String>();
                while (i.hasNext()) {
                    StringBuffer sbuf = new StringBuffer();
                    AstMethod m = (AstMethod)i.next();
                    sbuf.append(m.getElementName()).append('(');
                    AstVariable[] params = m.getParameters();
                    int j = 0;
                    while (j < params.length) {
                        if (j > 0) {
                            sbuf.append(", ");
                        }
                        sbuf.append(params[j].getType().getTypeName());
                        ++j;
                    }
                    sbuf.append(')');
                    array.add(sbuf.toString());
                }
                this.message((AstObject)method, "AuditOWS.1", new Object[]{array.toArray(new String[0])});
                return;
            }
            superclass = superclass.getSuperClass();
        }
    }

    private HashSet checkAncestorType(AstMethod method, AstType superclass) {
        HashSet setOverMethods = this.getOverMethods(superclass, method.getElementName());
        Iterator it = setOverMethods.iterator();
        while (it.hasNext()) {
            AstMethod overMethod = (AstMethod)it.next();
            if (method.getDeclaringType().findMethod(overMethod.getElementName(), overMethod.getSignature(), false) == null) continue;
            it.remove();
        }
        return setOverMethods;
    }

    private HashSet getOverMethods(AstType type, String name) {
        HashSet<AstMethod> set = new HashSet<AstMethod>();
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (name.equals(methods[i].getElementName())) {
                set.add(methods[i]);
            }
            ++i;
        }
        return set;
    }
}

