/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ONE
extends AuditRule {
    public ONE() {
        super(8);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (result != null && !Util.isZero(result) && !Util.isConstant(operands)) {
            switch (tuple.getCode()) {
                case 4: {
                    if (!Util.isZero(values[0]) && !Util.isZero(values[1])) break;
                    this.message(tuple.getAstObject(), new Object[]{new Integer(4), new Integer(Util.isZero(values[0]) ? 1 : 2)});
                    break;
                }
                case 5: {
                    if (!Util.isZero(values[1])) break;
                    this.message(tuple.getAstObject(), new Object[]{new Integer(5)});
                    break;
                }
                case 1: {
                    if (!Util.isOne(values[0]) && !Util.isOne(values[1])) break;
                    this.message(tuple.getAstObject(), new Object[]{new Integer(1), new Integer(Util.isZero(values[0]) ? 1 : 2)});
                    break;
                }
                case 2: {
                    if (!Util.isOne(values[1])) break;
                    this.message(tuple.getAstObject(), new Object[]{new Integer(2)});
                    break;
                }
                case 3: {
                    if (!(values[0] instanceof IIntegralDomain) || !(values[1] instanceof IIntegralDomain)) break;
                    IIntegralDomain left = (IIntegralDomain)values[0];
                    IIntegralDomain right = (IIntegralDomain)values[1];
                    if ((right.getLowValue() <= 0L || left.getHighValue() >= right.getLowValue() || left.getLowValue() <= -right.getLowValue()) && (right.getHighValue() >= 0L || -left.getHighValue() <= right.getHighValue() || left.getLowValue() <= right.getHighValue())) break;
                    this.message(tuple.getAstObject(), new Object[]{left, right});
                    break;
                }
            }
        }
    }

    public String getExplainMessage(AstObject ast, String messageId, Object[] values) {
        if (values != null) {
            String tmplFileName = null;
            if (values[0] instanceof Integer) {
                int key = (Integer)values[0];
                switch (key) {
                    case 4: {
                        tmplFileName = "com.togethersoft.sca.internal.plugin.audit.impl.ONE_1";
                        break;
                    }
                    case 5: {
                        tmplFileName = "com.togethersoft.sca.internal.plugin.audit.impl.ONE_2";
                        break;
                    }
                    case 1: {
                        tmplFileName = "com.togethersoft.sca.internal.plugin.audit.impl.ONE_3";
                        break;
                    }
                    case 2: {
                        tmplFileName = "com.togethersoft.sca.internal.plugin.audit.impl.ONE_4";
                    }
                }
            } else {
                tmplFileName = "com.togethersoft.sca.internal.plugin.audit.impl.ONE_5";
            }
            return super.getExplainMessage(tmplFileName, ast, messageId, values);
        }
        return super.getExplainMessage(ast, messageId, values);
    }
}

