/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ONAMAM
extends AuditRule {
    public ONAMAM() {
        super(4);
    }

    public void checkMethod(AstMethod method) {
        if (!method.isAbstract()) {
            return;
        }
        AstType type = method.getDeclaringType();
        if (type.isInterface()) {
            return;
        }
        AstType superClass = type.getSuperClass();
        while (superClass != null) {
            AstMethod ovr = superClass.findMethod(method.getElementName(), method.getSignature(), false);
            if (ovr != null && !ovr.isAbstract()) {
                this.message((AstObject)method, "AuditONAMAM.1", new Object[]{method});
                return;
            }
            superClass = superClass.getSuperClass();
        }
    }
}

