/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstModifier;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class OIM
extends AuditRule {
    public OIM() {
        super(4);
    }

    public void checkType(final AstType type) {
        IAuditMessage m;
        if (type.isInterface() && (type.getDeclaredModifiers() & 0x400) != 0 && (m = this.message((AstObject)type)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditOIM.Autofix"){

                public boolean fix() {
                    type.setDeclaredModifiers(type.getDeclaredModifiers() & 0xFFFFFBFF);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            AstModifier[] modifiers = type.getModifiersList();
            int i = 0;
            while (i < modifiers.length) {
                if ((modifiers[i].getModifier() & 0x400) != 0) {
                    fix.removeWithSpace(modifiers[i].getPosition());
                }
                ++i;
            }
        }
    }
}

